/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.SecurityGroupType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class SecurityGroupTypeNode
extends BaseObjectTypeNode
implements SecurityGroupType {
    public SecurityGroupTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getSecurityGroupId() throws UaException {
        PropertyTypeNode node = this.getSecurityGroupIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityGroupId(String value) throws UaException {
        PropertyTypeNode node = this.getSecurityGroupIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecurityGroupId() throws UaException {
        try {
            return this.readSecurityGroupIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityGroupId(String value) throws UaException {
        try {
            this.writeSecurityGroupIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityGroupIdAsync() {
        return ((CompletableFuture)this.getSecurityGroupIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityGroupIdAsync(String securityGroupId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityGroupId));
        return this.getSecurityGroupIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityGroupIdNode() throws UaException {
        try {
            return this.getSecurityGroupIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityGroupIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityGroupId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getKeyLifetime() throws UaException {
        PropertyTypeNode node = this.getKeyLifetimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setKeyLifetime(Double value) throws UaException {
        PropertyTypeNode node = this.getKeyLifetimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readKeyLifetime() throws UaException {
        try {
            return this.readKeyLifetimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeKeyLifetime(Double value) throws UaException {
        try {
            this.writeKeyLifetimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readKeyLifetimeAsync() {
        return ((CompletableFuture)this.getKeyLifetimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeKeyLifetimeAsync(Double keyLifetime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)keyLifetime));
        return this.getKeyLifetimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getKeyLifetimeNode() throws UaException {
        try {
            return this.getKeyLifetimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getKeyLifetimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "KeyLifetime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecurityPolicyUri() throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityPolicyUri(String value) throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecurityPolicyUri() throws UaException {
        try {
            return this.readSecurityPolicyUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityPolicyUri(String value) throws UaException {
        try {
            this.writeSecurityPolicyUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityPolicyUriAsync() {
        return ((CompletableFuture)this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityPolicyUriAsync(String securityPolicyUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityPolicyUri));
        return this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityPolicyUriNode() throws UaException {
        try {
            return this.getSecurityPolicyUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityPolicyUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxFutureKeyCount() throws UaException {
        PropertyTypeNode node = this.getMaxFutureKeyCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxFutureKeyCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxFutureKeyCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxFutureKeyCount() throws UaException {
        try {
            return this.readMaxFutureKeyCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxFutureKeyCount(UInteger value) throws UaException {
        try {
            this.writeMaxFutureKeyCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxFutureKeyCountAsync() {
        return ((CompletableFuture)this.getMaxFutureKeyCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxFutureKeyCountAsync(UInteger maxFutureKeyCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxFutureKeyCount));
        return this.getMaxFutureKeyCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxFutureKeyCountNode() throws UaException {
        try {
            return this.getMaxFutureKeyCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxFutureKeyCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxFutureKeyCount", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxPastKeyCount() throws UaException {
        PropertyTypeNode node = this.getMaxPastKeyCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxPastKeyCount(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxPastKeyCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxPastKeyCount() throws UaException {
        try {
            return this.readMaxPastKeyCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxPastKeyCount(UInteger value) throws UaException {
        try {
            this.writeMaxPastKeyCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxPastKeyCountAsync() {
        return ((CompletableFuture)this.getMaxPastKeyCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxPastKeyCountAsync(UInteger maxPastKeyCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxPastKeyCount));
        return this.getMaxPastKeyCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxPastKeyCountNode() throws UaException {
        try {
            return this.getMaxPastKeyCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxPastKeyCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxPastKeyCount", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

