/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ExtensionFieldsTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PublishedDataSetType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ConfigurationVersionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.DataSetMetaDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PublishedDataSetTypeNode
extends BaseObjectTypeNode
implements PublishedDataSetType {
    public PublishedDataSetTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ConfigurationVersionDataType getConfigurationVersion() throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        return this.cast(node.getValue().getValue().getValue(), ConfigurationVersionDataType.class);
    }

    @Override
    public void setConfigurationVersion(ConfigurationVersionDataType value) throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ConfigurationVersionDataType readConfigurationVersion() throws UaException {
        try {
            return this.readConfigurationVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConfigurationVersion(ConfigurationVersionDataType value) throws UaException {
        try {
            this.writeConfigurationVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ConfigurationVersionDataType> readConfigurationVersionAsync() {
        return ((CompletableFuture)this.getConfigurationVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ConfigurationVersionDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeConfigurationVersionAsync(ConfigurationVersionDataType configurationVersion) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)configurationVersion);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getConfigurationVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConfigurationVersionNode() throws UaException {
        try {
            return this.getConfigurationVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConfigurationVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfigurationVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DataSetMetaDataType getDataSetMetaData() throws UaException {
        PropertyTypeNode node = this.getDataSetMetaDataNode();
        return this.cast(node.getValue().getValue().getValue(), DataSetMetaDataType.class);
    }

    @Override
    public void setDataSetMetaData(DataSetMetaDataType value) throws UaException {
        PropertyTypeNode node = this.getDataSetMetaDataNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public DataSetMetaDataType readDataSetMetaData() throws UaException {
        try {
            return this.readDataSetMetaDataAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetMetaData(DataSetMetaDataType value) throws UaException {
        try {
            this.writeDataSetMetaDataAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DataSetMetaDataType> readDataSetMetaDataAsync() {
        return ((CompletableFuture)this.getDataSetMetaDataNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), DataSetMetaDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetMetaDataAsync(DataSetMetaDataType dataSetMetaData) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)dataSetMetaData);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDataSetMetaDataNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetMetaDataNode() throws UaException {
        try {
            return this.getDataSetMetaDataNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetMetaDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetMetaData", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UUID getDataSetClassId() throws UaException {
        PropertyTypeNode node = this.getDataSetClassIdNode();
        return (UUID)node.getValue().getValue().getValue();
    }

    @Override
    public void setDataSetClassId(UUID value) throws UaException {
        PropertyTypeNode node = this.getDataSetClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UUID readDataSetClassId() throws UaException {
        try {
            return this.readDataSetClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDataSetClassId(UUID value) throws UaException {
        try {
            this.writeDataSetClassIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UUID> readDataSetClassIdAsync() {
        return ((CompletableFuture)this.getDataSetClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UUID)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDataSetClassIdAsync(UUID dataSetClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)dataSetClassId));
        return this.getDataSetClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDataSetClassIdNode() throws UaException {
        try {
            return this.getDataSetClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDataSetClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DataSetClassId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getCyclicDataSet() throws UaException {
        PropertyTypeNode node = this.getCyclicDataSetNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setCyclicDataSet(Boolean value) throws UaException {
        PropertyTypeNode node = this.getCyclicDataSetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readCyclicDataSet() throws UaException {
        try {
            return this.readCyclicDataSetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCyclicDataSet(Boolean value) throws UaException {
        try {
            this.writeCyclicDataSetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readCyclicDataSetAsync() {
        return ((CompletableFuture)this.getCyclicDataSetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCyclicDataSetAsync(Boolean cyclicDataSet) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)cyclicDataSet));
        return this.getCyclicDataSetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCyclicDataSetNode() throws UaException {
        try {
            return this.getCyclicDataSetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCyclicDataSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CyclicDataSet", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ExtensionFieldsTypeNode getExtensionFieldsNode() throws UaException {
        try {
            return this.getExtensionFieldsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ExtensionFieldsTypeNode> getExtensionFieldsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ExtensionFields", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ExtensionFieldsTypeNode)node);
    }
}

