/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PubSubDiagnosticsCounterTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.DiagnosticsLevel;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PubSubDiagnosticsTypeNode
extends BaseObjectTypeNode
implements PubSubDiagnosticsType {
    public PubSubDiagnosticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public DiagnosticsLevel getDiagnosticsLevel() throws UaException {
        BaseDataVariableTypeNode node = this.getDiagnosticsLevelNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return DiagnosticsLevel.from((int)((Integer)value));
        }
        if (value instanceof DiagnosticsLevel) {
            return (DiagnosticsLevel)value;
        }
        return null;
    }

    @Override
    public void setDiagnosticsLevel(DiagnosticsLevel value) throws UaException {
        BaseDataVariableTypeNode node = this.getDiagnosticsLevelNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DiagnosticsLevel readDiagnosticsLevel() throws UaException {
        try {
            return this.readDiagnosticsLevelAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDiagnosticsLevel(DiagnosticsLevel value) throws UaException {
        try {
            this.writeDiagnosticsLevelAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DiagnosticsLevel> readDiagnosticsLevelAsync() {
        return ((CompletableFuture)this.getDiagnosticsLevelNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return DiagnosticsLevel.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeDiagnosticsLevelAsync(DiagnosticsLevel diagnosticsLevel) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)diagnosticsLevel));
        return this.getDiagnosticsLevelNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDiagnosticsLevelNode() throws UaException {
        try {
            return this.getDiagnosticsLevelNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDiagnosticsLevelNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DiagnosticsLevel", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getTotalInformation() throws UaException {
        PubSubDiagnosticsCounterTypeNode node = this.getTotalInformationNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTotalInformation(UInteger value) throws UaException {
        PubSubDiagnosticsCounterTypeNode node = this.getTotalInformationNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTotalInformation() throws UaException {
        try {
            return this.readTotalInformationAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTotalInformation(UInteger value) throws UaException {
        try {
            this.writeTotalInformationAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTotalInformationAsync() {
        return ((CompletableFuture)this.getTotalInformationNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTotalInformationAsync(UInteger totalInformation) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)totalInformation));
        return this.getTotalInformationNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PubSubDiagnosticsCounterTypeNode getTotalInformationNode() throws UaException {
        try {
            return this.getTotalInformationNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsCounterTypeNode> getTotalInformationNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TotalInformation", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsCounterTypeNode)node);
    }

    @Override
    public UInteger getTotalError() throws UaException {
        PubSubDiagnosticsCounterTypeNode node = this.getTotalErrorNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTotalError(UInteger value) throws UaException {
        PubSubDiagnosticsCounterTypeNode node = this.getTotalErrorNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTotalError() throws UaException {
        try {
            return this.readTotalErrorAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTotalError(UInteger value) throws UaException {
        try {
            this.writeTotalErrorAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTotalErrorAsync() {
        return ((CompletableFuture)this.getTotalErrorNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTotalErrorAsync(UInteger totalError) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)totalError));
        return this.getTotalErrorNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PubSubDiagnosticsCounterTypeNode getTotalErrorNode() throws UaException {
        try {
            return this.getTotalErrorNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsCounterTypeNode> getTotalErrorNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TotalError", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsCounterTypeNode)node);
    }

    @Override
    public Boolean getSubError() throws UaException {
        BaseDataVariableTypeNode node = this.getSubErrorNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSubError(Boolean value) throws UaException {
        BaseDataVariableTypeNode node = this.getSubErrorNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSubError() throws UaException {
        try {
            return this.readSubErrorAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSubError(Boolean value) throws UaException {
        try {
            this.writeSubErrorAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSubErrorAsync() {
        return ((CompletableFuture)this.getSubErrorNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSubErrorAsync(Boolean subError) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)subError));
        return this.getSubErrorNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSubErrorNode() throws UaException {
        try {
            return this.getSubErrorNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSubErrorNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SubError", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public BaseObjectTypeNode getCountersNode() throws UaException {
        try {
            return this.getCountersNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseObjectTypeNode> getCountersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Counters", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseObjectTypeNode)node);
    }

    @Override
    public BaseObjectTypeNode getLiveValuesNode() throws UaException {
        try {
            return this.getLiveValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseObjectTypeNode> getLiveValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LiveValues", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseObjectTypeNode)node);
    }
}

