/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ConnectionTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.NetworkAddressTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubConnectionType;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubDiagnosticsConnectionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubStatusTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.SelectionListTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.KeyValuePair;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PubSubConnectionTypeNode
extends BaseObjectTypeNode
implements PubSubConnectionType {
    public PubSubConnectionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public Object getPublisherId() throws UaException {
        PropertyTypeNode node = this.getPublisherIdNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setPublisherId(Object value) throws UaException {
        PropertyTypeNode node = this.getPublisherIdNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readPublisherId() throws UaException {
        try {
            return this.readPublisherIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublisherId(Object value) throws UaException {
        try {
            this.writePublisherIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<?> readPublisherIdAsync() {
        return ((CompletableFuture)this.getPublisherIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePublisherIdAsync(Object publisherId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(publisherId));
        return this.getPublisherIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPublisherIdNode() throws UaException {
        try {
            return this.getPublisherIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPublisherIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublisherId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public KeyValuePair[] getConnectionProperties() throws UaException {
        PropertyTypeNode node = this.getConnectionPropertiesNode();
        return this.cast(node.getValue().getValue().getValue(), KeyValuePair[].class);
    }

    @Override
    public void setConnectionProperties(KeyValuePair[] value) throws UaException {
        PropertyTypeNode node = this.getConnectionPropertiesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public KeyValuePair[] readConnectionProperties() throws UaException {
        try {
            return this.readConnectionPropertiesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConnectionProperties(KeyValuePair[] value) throws UaException {
        try {
            this.writeConnectionPropertiesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends KeyValuePair[]> readConnectionPropertiesAsync() {
        return ((CompletableFuture)this.getConnectionPropertiesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), KeyValuePair[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeConnectionPropertiesAsync(KeyValuePair[] connectionProperties) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])connectionProperties);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getConnectionPropertiesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConnectionPropertiesNode() throws UaException {
        try {
            return this.getConnectionPropertiesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConnectionPropertiesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConnectionProperties", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getTransportProfileUri() throws UaException {
        SelectionListTypeNode node = this.getTransportProfileUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setTransportProfileUri(String value) throws UaException {
        SelectionListTypeNode node = this.getTransportProfileUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readTransportProfileUri() throws UaException {
        try {
            return this.readTransportProfileUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransportProfileUri(String value) throws UaException {
        try {
            this.writeTransportProfileUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readTransportProfileUriAsync() {
        return ((CompletableFuture)this.getTransportProfileUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTransportProfileUriAsync(String transportProfileUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)transportProfileUri));
        return this.getTransportProfileUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public SelectionListTypeNode getTransportProfileUriNode() throws UaException {
        try {
            return this.getTransportProfileUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends SelectionListTypeNode> getTransportProfileUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportProfileUri", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (SelectionListTypeNode)node);
    }

    @Override
    public NetworkAddressTypeNode getAddressNode() throws UaException {
        try {
            return this.getAddressNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends NetworkAddressTypeNode> getAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Address", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (NetworkAddressTypeNode)node);
    }

    @Override
    public ConnectionTransportTypeNode getTransportSettingsNode() throws UaException {
        try {
            return this.getTransportSettingsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ConnectionTransportTypeNode> getTransportSettingsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransportSettings", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ConnectionTransportTypeNode)node);
    }

    @Override
    public PubSubStatusTypeNode getStatusNode() throws UaException {
        try {
            return this.getStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PubSubStatusTypeNode> getStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Status", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (PubSubStatusTypeNode)node);
    }

    @Override
    public PubSubDiagnosticsConnectionTypeNode getDiagnosticsNode() throws UaException {
        try {
            return this.getDiagnosticsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PubSubDiagnosticsConnectionTypeNode> getDiagnosticsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Diagnostics", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (PubSubDiagnosticsConnectionTypeNode)node);
    }
}

