/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.PubSubCapabilitiesType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class PubSubCapabilitiesTypeNode
extends BaseObjectTypeNode
implements PubSubCapabilitiesType {
    public PubSubCapabilitiesTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getMaxPubSubConnections() throws UaException {
        PropertyTypeNode node = this.getMaxPubSubConnectionsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxPubSubConnections(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxPubSubConnectionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxPubSubConnections() throws UaException {
        try {
            return this.readMaxPubSubConnectionsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxPubSubConnections(UInteger value) throws UaException {
        try {
            this.writeMaxPubSubConnectionsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxPubSubConnectionsAsync() {
        return ((CompletableFuture)this.getMaxPubSubConnectionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxPubSubConnectionsAsync(UInteger maxPubSubConnections) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxPubSubConnections));
        return this.getMaxPubSubConnectionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxPubSubConnectionsNode() throws UaException {
        try {
            return this.getMaxPubSubConnectionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxPubSubConnectionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxPubSubConnections", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxWriterGroups() throws UaException {
        PropertyTypeNode node = this.getMaxWriterGroupsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxWriterGroups(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxWriterGroupsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxWriterGroups() throws UaException {
        try {
            return this.readMaxWriterGroupsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxWriterGroups(UInteger value) throws UaException {
        try {
            this.writeMaxWriterGroupsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxWriterGroupsAsync() {
        return ((CompletableFuture)this.getMaxWriterGroupsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxWriterGroupsAsync(UInteger maxWriterGroups) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxWriterGroups));
        return this.getMaxWriterGroupsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxWriterGroupsNode() throws UaException {
        try {
            return this.getMaxWriterGroupsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxWriterGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxWriterGroups", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxReaderGroups() throws UaException {
        PropertyTypeNode node = this.getMaxReaderGroupsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxReaderGroups(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxReaderGroupsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxReaderGroups() throws UaException {
        try {
            return this.readMaxReaderGroupsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxReaderGroups(UInteger value) throws UaException {
        try {
            this.writeMaxReaderGroupsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxReaderGroupsAsync() {
        return ((CompletableFuture)this.getMaxReaderGroupsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxReaderGroupsAsync(UInteger maxReaderGroups) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxReaderGroups));
        return this.getMaxReaderGroupsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxReaderGroupsNode() throws UaException {
        try {
            return this.getMaxReaderGroupsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxReaderGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxReaderGroups", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxDataSetWriters() throws UaException {
        PropertyTypeNode node = this.getMaxDataSetWritersNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxDataSetWriters(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxDataSetWritersNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxDataSetWriters() throws UaException {
        try {
            return this.readMaxDataSetWritersAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxDataSetWriters(UInteger value) throws UaException {
        try {
            this.writeMaxDataSetWritersAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxDataSetWritersAsync() {
        return ((CompletableFuture)this.getMaxDataSetWritersNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxDataSetWritersAsync(UInteger maxDataSetWriters) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxDataSetWriters));
        return this.getMaxDataSetWritersNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxDataSetWritersNode() throws UaException {
        try {
            return this.getMaxDataSetWritersNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxDataSetWritersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxDataSetWriters", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxDataSetReaders() throws UaException {
        PropertyTypeNode node = this.getMaxDataSetReadersNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxDataSetReaders(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxDataSetReadersNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxDataSetReaders() throws UaException {
        try {
            return this.readMaxDataSetReadersAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxDataSetReaders(UInteger value) throws UaException {
        try {
            this.writeMaxDataSetReadersAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxDataSetReadersAsync() {
        return ((CompletableFuture)this.getMaxDataSetReadersNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxDataSetReadersAsync(UInteger maxDataSetReaders) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxDataSetReaders));
        return this.getMaxDataSetReadersNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxDataSetReadersNode() throws UaException {
        try {
            return this.getMaxDataSetReadersNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxDataSetReadersNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxDataSetReaders", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxFieldsPerDataSet() throws UaException {
        PropertyTypeNode node = this.getMaxFieldsPerDataSetNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxFieldsPerDataSet(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxFieldsPerDataSetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxFieldsPerDataSet() throws UaException {
        try {
            return this.readMaxFieldsPerDataSetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxFieldsPerDataSet(UInteger value) throws UaException {
        try {
            this.writeMaxFieldsPerDataSetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxFieldsPerDataSetAsync() {
        return ((CompletableFuture)this.getMaxFieldsPerDataSetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxFieldsPerDataSetAsync(UInteger maxFieldsPerDataSet) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxFieldsPerDataSet));
        return this.getMaxFieldsPerDataSetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxFieldsPerDataSetNode() throws UaException {
        try {
            return this.getMaxFieldsPerDataSetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxFieldsPerDataSetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxFieldsPerDataSet", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxDataSetWritersPerGroup() throws UaException {
        PropertyTypeNode node = this.getMaxDataSetWritersPerGroupNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxDataSetWritersPerGroup(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxDataSetWritersPerGroupNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxDataSetWritersPerGroup() throws UaException {
        try {
            return this.readMaxDataSetWritersPerGroupAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxDataSetWritersPerGroup(UInteger value) throws UaException {
        try {
            this.writeMaxDataSetWritersPerGroupAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxDataSetWritersPerGroupAsync() {
        return ((CompletableFuture)this.getMaxDataSetWritersPerGroupNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxDataSetWritersPerGroupAsync(UInteger maxDataSetWritersPerGroup) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxDataSetWritersPerGroup));
        return this.getMaxDataSetWritersPerGroupNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxDataSetWritersPerGroupNode() throws UaException {
        try {
            return this.getMaxDataSetWritersPerGroupNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxDataSetWritersPerGroupNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxDataSetWritersPerGroup", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxSecurityGroups() throws UaException {
        PropertyTypeNode node = this.getMaxSecurityGroupsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxSecurityGroups(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxSecurityGroupsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxSecurityGroups() throws UaException {
        try {
            return this.readMaxSecurityGroupsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxSecurityGroups(UInteger value) throws UaException {
        try {
            this.writeMaxSecurityGroupsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxSecurityGroupsAsync() {
        return ((CompletableFuture)this.getMaxSecurityGroupsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxSecurityGroupsAsync(UInteger maxSecurityGroups) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxSecurityGroups));
        return this.getMaxSecurityGroupsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxSecurityGroupsNode() throws UaException {
        try {
            return this.getMaxSecurityGroupsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxSecurityGroupsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxSecurityGroups", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxPushTargets() throws UaException {
        PropertyTypeNode node = this.getMaxPushTargetsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxPushTargets(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxPushTargetsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxPushTargets() throws UaException {
        try {
            return this.readMaxPushTargetsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxPushTargets(UInteger value) throws UaException {
        try {
            this.writeMaxPushTargetsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxPushTargetsAsync() {
        return ((CompletableFuture)this.getMaxPushTargetsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxPushTargetsAsync(UInteger maxPushTargets) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxPushTargets));
        return this.getMaxPushTargetsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxPushTargetsNode() throws UaException {
        try {
            return this.getMaxPushTargetsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxPushTargetsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxPushTargets", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxPublishedDataSets() throws UaException {
        PropertyTypeNode node = this.getMaxPublishedDataSetsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxPublishedDataSets(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxPublishedDataSetsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxPublishedDataSets() throws UaException {
        try {
            return this.readMaxPublishedDataSetsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxPublishedDataSets(UInteger value) throws UaException {
        try {
            this.writeMaxPublishedDataSetsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxPublishedDataSetsAsync() {
        return ((CompletableFuture)this.getMaxPublishedDataSetsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxPublishedDataSetsAsync(UInteger maxPublishedDataSets) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxPublishedDataSets));
        return this.getMaxPublishedDataSetsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxPublishedDataSetsNode() throws UaException {
        try {
            return this.getMaxPublishedDataSetsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxPublishedDataSetsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxPublishedDataSets", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxStandaloneSubscribedDataSets() throws UaException {
        PropertyTypeNode node = this.getMaxStandaloneSubscribedDataSetsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxStandaloneSubscribedDataSets(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxStandaloneSubscribedDataSetsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxStandaloneSubscribedDataSets() throws UaException {
        try {
            return this.readMaxStandaloneSubscribedDataSetsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxStandaloneSubscribedDataSets(UInteger value) throws UaException {
        try {
            this.writeMaxStandaloneSubscribedDataSetsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxStandaloneSubscribedDataSetsAsync() {
        return ((CompletableFuture)this.getMaxStandaloneSubscribedDataSetsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxStandaloneSubscribedDataSetsAsync(UInteger maxStandaloneSubscribedDataSets) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxStandaloneSubscribedDataSets));
        return this.getMaxStandaloneSubscribedDataSetsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxStandaloneSubscribedDataSetsNode() throws UaException {
        try {
            return this.getMaxStandaloneSubscribedDataSetsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxStandaloneSubscribedDataSetsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxStandaloneSubscribedDataSets", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNetworkMessageSizeDatagram() throws UaException {
        PropertyTypeNode node = this.getMaxNetworkMessageSizeDatagramNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNetworkMessageSizeDatagram(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNetworkMessageSizeDatagramNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNetworkMessageSizeDatagram() throws UaException {
        try {
            return this.readMaxNetworkMessageSizeDatagramAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNetworkMessageSizeDatagram(UInteger value) throws UaException {
        try {
            this.writeMaxNetworkMessageSizeDatagramAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNetworkMessageSizeDatagramAsync() {
        return ((CompletableFuture)this.getMaxNetworkMessageSizeDatagramNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNetworkMessageSizeDatagramAsync(UInteger maxNetworkMessageSizeDatagram) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNetworkMessageSizeDatagram));
        return this.getMaxNetworkMessageSizeDatagramNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNetworkMessageSizeDatagramNode() throws UaException {
        try {
            return this.getMaxNetworkMessageSizeDatagramNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNetworkMessageSizeDatagramNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNetworkMessageSizeDatagram", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxNetworkMessageSizeBroker() throws UaException {
        PropertyTypeNode node = this.getMaxNetworkMessageSizeBrokerNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxNetworkMessageSizeBroker(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxNetworkMessageSizeBrokerNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxNetworkMessageSizeBroker() throws UaException {
        try {
            return this.readMaxNetworkMessageSizeBrokerAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxNetworkMessageSizeBroker(UInteger value) throws UaException {
        try {
            this.writeMaxNetworkMessageSizeBrokerAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxNetworkMessageSizeBrokerAsync() {
        return ((CompletableFuture)this.getMaxNetworkMessageSizeBrokerNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxNetworkMessageSizeBrokerAsync(UInteger maxNetworkMessageSizeBroker) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxNetworkMessageSizeBroker));
        return this.getMaxNetworkMessageSizeBrokerNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxNetworkMessageSizeBrokerNode() throws UaException {
        try {
            return this.getMaxNetworkMessageSizeBrokerNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxNetworkMessageSizeBrokerNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxNetworkMessageSizeBroker", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSupportSecurityKeyPull() throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyPullNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportSecurityKeyPull(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyPullNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSupportSecurityKeyPull() throws UaException {
        try {
            return this.readSupportSecurityKeyPullAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSupportSecurityKeyPull(Boolean value) throws UaException {
        try {
            this.writeSupportSecurityKeyPullAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSupportSecurityKeyPullAsync() {
        return ((CompletableFuture)this.getSupportSecurityKeyPullNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportSecurityKeyPullAsync(Boolean supportSecurityKeyPull) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportSecurityKeyPull));
        return this.getSupportSecurityKeyPullNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportSecurityKeyPullNode() throws UaException {
        try {
            return this.getSupportSecurityKeyPullNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportSecurityKeyPullNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportSecurityKeyPull", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSupportSecurityKeyPush() throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyPushNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportSecurityKeyPush(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyPushNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSupportSecurityKeyPush() throws UaException {
        try {
            return this.readSupportSecurityKeyPushAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSupportSecurityKeyPush(Boolean value) throws UaException {
        try {
            this.writeSupportSecurityKeyPushAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSupportSecurityKeyPushAsync() {
        return ((CompletableFuture)this.getSupportSecurityKeyPushNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportSecurityKeyPushAsync(Boolean supportSecurityKeyPush) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportSecurityKeyPush));
        return this.getSupportSecurityKeyPushNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportSecurityKeyPushNode() throws UaException {
        try {
            return this.getSupportSecurityKeyPushNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportSecurityKeyPushNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportSecurityKeyPush", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSupportSecurityKeyServer() throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyServerNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportSecurityKeyServer(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSupportSecurityKeyServerNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSupportSecurityKeyServer() throws UaException {
        try {
            return this.readSupportSecurityKeyServerAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSupportSecurityKeyServer(Boolean value) throws UaException {
        try {
            this.writeSupportSecurityKeyServerAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSupportSecurityKeyServerAsync() {
        return ((CompletableFuture)this.getSupportSecurityKeyServerNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportSecurityKeyServerAsync(Boolean supportSecurityKeyServer) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportSecurityKeyServer));
        return this.getSupportSecurityKeyServerNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportSecurityKeyServerNode() throws UaException {
        try {
            return this.getSupportSecurityKeyServerNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportSecurityKeyServerNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportSecurityKeyServer", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

