/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AddressSpaceFileTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.NamespaceMetadataType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class NamespaceMetadataTypeNode
extends BaseObjectTypeNode
implements NamespaceMetadataType {
    public NamespaceMetadataTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getNamespaceUri() throws UaException {
        PropertyTypeNode node = this.getNamespaceUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceUri(String value) throws UaException {
        PropertyTypeNode node = this.getNamespaceUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readNamespaceUri() throws UaException {
        try {
            return this.readNamespaceUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceUri(String value) throws UaException {
        try {
            this.writeNamespaceUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readNamespaceUriAsync() {
        return ((CompletableFuture)this.getNamespaceUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceUriAsync(String namespaceUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceUri));
        return this.getNamespaceUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceUriNode() throws UaException {
        try {
            return this.getNamespaceUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getNamespaceVersion() throws UaException {
        PropertyTypeNode node = this.getNamespaceVersionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespaceVersion(String value) throws UaException {
        PropertyTypeNode node = this.getNamespaceVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readNamespaceVersion() throws UaException {
        try {
            return this.readNamespaceVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespaceVersion(String value) throws UaException {
        try {
            this.writeNamespaceVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readNamespaceVersionAsync() {
        return ((CompletableFuture)this.getNamespaceVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespaceVersionAsync(String namespaceVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespaceVersion));
        return this.getNamespaceVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespaceVersionNode() throws UaException {
        try {
            return this.getNamespaceVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespaceVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getNamespacePublicationDate() throws UaException {
        PropertyTypeNode node = this.getNamespacePublicationDateNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setNamespacePublicationDate(DateTime value) throws UaException {
        PropertyTypeNode node = this.getNamespacePublicationDateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readNamespacePublicationDate() throws UaException {
        try {
            return this.readNamespacePublicationDateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNamespacePublicationDate(DateTime value) throws UaException {
        try {
            this.writeNamespacePublicationDateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readNamespacePublicationDateAsync() {
        return ((CompletableFuture)this.getNamespacePublicationDateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeNamespacePublicationDateAsync(DateTime namespacePublicationDate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)namespacePublicationDate));
        return this.getNamespacePublicationDateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNamespacePublicationDateNode() throws UaException {
        try {
            return this.getNamespacePublicationDateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNamespacePublicationDateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespacePublicationDate", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getIsNamespaceSubset() throws UaException {
        PropertyTypeNode node = this.getIsNamespaceSubsetNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setIsNamespaceSubset(Boolean value) throws UaException {
        PropertyTypeNode node = this.getIsNamespaceSubsetNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readIsNamespaceSubset() throws UaException {
        try {
            return this.readIsNamespaceSubsetAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeIsNamespaceSubset(Boolean value) throws UaException {
        try {
            this.writeIsNamespaceSubsetAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readIsNamespaceSubsetAsync() {
        return ((CompletableFuture)this.getIsNamespaceSubsetNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeIsNamespaceSubsetAsync(Boolean isNamespaceSubset) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)isNamespaceSubset));
        return this.getIsNamespaceSubsetNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIsNamespaceSubsetNode() throws UaException {
        try {
            return this.getIsNamespaceSubsetNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIsNamespaceSubsetNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "IsNamespaceSubset", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public IdType[] getStaticNodeIdTypes() throws UaException {
        PropertyTypeNode node = this.getStaticNodeIdTypesNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer[]) {
            Integer[] values = (Integer[])value;
            IdType[] staticNodeIdTypes = new IdType[values.length];
            for (int i = 0; i < values.length; ++i) {
                staticNodeIdTypes[i] = IdType.from((int)values[i]);
            }
            return staticNodeIdTypes;
        }
        if (value instanceof IdType[]) {
            return (IdType[])value;
        }
        return null;
    }

    @Override
    public void setStaticNodeIdTypes(IdType[] value) throws UaException {
        PropertyTypeNode node = this.getStaticNodeIdTypesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public IdType[] readStaticNodeIdTypes() throws UaException {
        try {
            return this.readStaticNodeIdTypesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticNodeIdTypes(IdType[] value) throws UaException {
        try {
            this.writeStaticNodeIdTypesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends IdType[]> readStaticNodeIdTypesAsync() {
        return ((CompletableFuture)this.getStaticNodeIdTypesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer[]) {
                Integer[] values = (Integer[])value;
                IdType[] staticNodeIdTypes = new IdType[values.length];
                for (int i = 0; i < values.length; ++i) {
                    staticNodeIdTypes[i] = IdType.from((int)values[i]);
                }
                return staticNodeIdTypes;
            }
            if (value instanceof IdType[]) {
                return (IdType[])value;
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticNodeIdTypesAsync(IdType[] staticNodeIdTypes) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticNodeIdTypes));
        return this.getStaticNodeIdTypesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticNodeIdTypesNode() throws UaException {
        try {
            return this.getStaticNodeIdTypesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticNodeIdTypesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticNodeIdTypes", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getStaticNumericNodeIdRange() throws UaException {
        PropertyTypeNode node = this.getStaticNumericNodeIdRangeNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setStaticNumericNodeIdRange(String[] value) throws UaException {
        PropertyTypeNode node = this.getStaticNumericNodeIdRangeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readStaticNumericNodeIdRange() throws UaException {
        try {
            return this.readStaticNumericNodeIdRangeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticNumericNodeIdRange(String[] value) throws UaException {
        try {
            this.writeStaticNumericNodeIdRangeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readStaticNumericNodeIdRangeAsync() {
        return ((CompletableFuture)this.getStaticNumericNodeIdRangeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticNumericNodeIdRangeAsync(String[] staticNumericNodeIdRange) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticNumericNodeIdRange));
        return this.getStaticNumericNodeIdRangeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticNumericNodeIdRangeNode() throws UaException {
        try {
            return this.getStaticNumericNodeIdRangeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticNumericNodeIdRangeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticNumericNodeIdRange", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getStaticStringNodeIdPattern() throws UaException {
        PropertyTypeNode node = this.getStaticStringNodeIdPatternNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setStaticStringNodeIdPattern(String value) throws UaException {
        PropertyTypeNode node = this.getStaticStringNodeIdPatternNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readStaticStringNodeIdPattern() throws UaException {
        try {
            return this.readStaticStringNodeIdPatternAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStaticStringNodeIdPattern(String value) throws UaException {
        try {
            this.writeStaticStringNodeIdPatternAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readStaticStringNodeIdPatternAsync() {
        return ((CompletableFuture)this.getStaticStringNodeIdPatternNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStaticStringNodeIdPatternAsync(String staticStringNodeIdPattern) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)staticStringNodeIdPattern));
        return this.getStaticStringNodeIdPatternNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStaticStringNodeIdPatternNode() throws UaException {
        try {
            return this.getStaticStringNodeIdPatternNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStaticStringNodeIdPatternNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StaticStringNodeIdPattern", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public RolePermissionType[] getDefaultRolePermissions() throws UaException {
        PropertyTypeNode node = this.getDefaultRolePermissionsNode();
        return this.cast(node.getValue().getValue().getValue(), RolePermissionType[].class);
    }

    @Override
    public void setDefaultRolePermissions(RolePermissionType[] value) throws UaException {
        PropertyTypeNode node = this.getDefaultRolePermissionsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public RolePermissionType[] readDefaultRolePermissions() throws UaException {
        try {
            return this.readDefaultRolePermissionsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDefaultRolePermissions(RolePermissionType[] value) throws UaException {
        try {
            this.writeDefaultRolePermissionsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends RolePermissionType[]> readDefaultRolePermissionsAsync() {
        return ((CompletableFuture)this.getDefaultRolePermissionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), RolePermissionType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultRolePermissionsAsync(RolePermissionType[] defaultRolePermissions) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])defaultRolePermissions);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDefaultRolePermissionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultRolePermissionsNode() throws UaException {
        try {
            return this.getDefaultRolePermissionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultRolePermissionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultRolePermissions", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public RolePermissionType[] getDefaultUserRolePermissions() throws UaException {
        PropertyTypeNode node = this.getDefaultUserRolePermissionsNode();
        return this.cast(node.getValue().getValue().getValue(), RolePermissionType[].class);
    }

    @Override
    public void setDefaultUserRolePermissions(RolePermissionType[] value) throws UaException {
        PropertyTypeNode node = this.getDefaultUserRolePermissionsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public RolePermissionType[] readDefaultUserRolePermissions() throws UaException {
        try {
            return this.readDefaultUserRolePermissionsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDefaultUserRolePermissions(RolePermissionType[] value) throws UaException {
        try {
            this.writeDefaultUserRolePermissionsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends RolePermissionType[]> readDefaultUserRolePermissionsAsync() {
        return ((CompletableFuture)this.getDefaultUserRolePermissionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), RolePermissionType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultUserRolePermissionsAsync(RolePermissionType[] defaultUserRolePermissions) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])defaultUserRolePermissions);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDefaultUserRolePermissionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultUserRolePermissionsNode() throws UaException {
        try {
            return this.getDefaultUserRolePermissionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultUserRolePermissionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultUserRolePermissions", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public AccessRestrictionType getDefaultAccessRestrictions() throws UaException {
        PropertyTypeNode node = this.getDefaultAccessRestrictionsNode();
        return (AccessRestrictionType)node.getValue().getValue().getValue();
    }

    @Override
    public void setDefaultAccessRestrictions(AccessRestrictionType value) throws UaException {
        PropertyTypeNode node = this.getDefaultAccessRestrictionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public AccessRestrictionType readDefaultAccessRestrictions() throws UaException {
        try {
            return this.readDefaultAccessRestrictionsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDefaultAccessRestrictions(AccessRestrictionType value) throws UaException {
        try {
            this.writeDefaultAccessRestrictionsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends AccessRestrictionType> readDefaultAccessRestrictionsAsync() {
        return ((CompletableFuture)this.getDefaultAccessRestrictionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (AccessRestrictionType)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDefaultAccessRestrictionsAsync(AccessRestrictionType defaultAccessRestrictions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)defaultAccessRestrictions));
        return this.getDefaultAccessRestrictionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDefaultAccessRestrictionsNode() throws UaException {
        try {
            return this.getDefaultAccessRestrictionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDefaultAccessRestrictionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DefaultAccessRestrictions", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getConfigurationVersion() throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setConfigurationVersion(UInteger value) throws UaException {
        PropertyTypeNode node = this.getConfigurationVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readConfigurationVersion() throws UaException {
        try {
            return this.readConfigurationVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConfigurationVersion(UInteger value) throws UaException {
        try {
            this.writeConfigurationVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readConfigurationVersionAsync() {
        return ((CompletableFuture)this.getConfigurationVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConfigurationVersionAsync(UInteger configurationVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)configurationVersion));
        return this.getConfigurationVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConfigurationVersionNode() throws UaException {
        try {
            return this.getConfigurationVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConfigurationVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConfigurationVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getModelVersion() throws UaException {
        PropertyTypeNode node = this.getModelVersionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setModelVersion(String value) throws UaException {
        PropertyTypeNode node = this.getModelVersionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readModelVersion() throws UaException {
        try {
            return this.readModelVersionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeModelVersion(String value) throws UaException {
        try {
            this.writeModelVersionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readModelVersionAsync() {
        return ((CompletableFuture)this.getModelVersionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeModelVersionAsync(String modelVersion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)modelVersion));
        return this.getModelVersionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getModelVersionNode() throws UaException {
        try {
            return this.getModelVersionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getModelVersionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModelVersion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public AddressSpaceFileTypeNode getNamespaceFileNode() throws UaException {
        try {
            return this.getNamespaceFileNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AddressSpaceFileTypeNode> getNamespaceFileNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NamespaceFile", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AddressSpaceFileTypeNode)node);
    }
}

