/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LldpRemoteSystemType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ChassisIdSubtype;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PortIdSubtype;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.LldpManagementAddressType;
import org.eclipse.milo.opcua.stack.core.types.structured.LldpSystemCapabilitiesMap;
import org.eclipse.milo.opcua.stack.core.types.structured.LldpTlvType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class LldpRemoteSystemTypeNode
extends BaseObjectTypeNode
implements LldpRemoteSystemType {
    public LldpRemoteSystemTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getTimeMark() throws UaException {
        BaseDataVariableTypeNode node = this.getTimeMarkNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setTimeMark(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getTimeMarkNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readTimeMark() throws UaException {
        try {
            return this.readTimeMarkAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTimeMark(UInteger value) throws UaException {
        try {
            this.writeTimeMarkAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readTimeMarkAsync() {
        return ((CompletableFuture)this.getTimeMarkNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTimeMarkAsync(UInteger timeMark) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)timeMark));
        return this.getTimeMarkNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTimeMarkNode() throws UaException {
        try {
            return this.getTimeMarkNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTimeMarkNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TimeMark", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRemoteIndex() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteIndexNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteIndex(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteIndexNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRemoteIndex() throws UaException {
        try {
            return this.readRemoteIndexAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteIndex(UInteger value) throws UaException {
        try {
            this.writeRemoteIndexAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRemoteIndexAsync() {
        return ((CompletableFuture)this.getRemoteIndexNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteIndexAsync(UInteger remoteIndex) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteIndex));
        return this.getRemoteIndexNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteIndexNode() throws UaException {
        try {
            return this.getRemoteIndexNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteIndexNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteIndex", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ChassisIdSubtype getChassisIdSubtype() throws UaException {
        BaseDataVariableTypeNode node = this.getChassisIdSubtypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ChassisIdSubtype.from((int)((Integer)value));
        }
        if (value instanceof ChassisIdSubtype) {
            return (ChassisIdSubtype)value;
        }
        return null;
    }

    @Override
    public void setChassisIdSubtype(ChassisIdSubtype value) throws UaException {
        BaseDataVariableTypeNode node = this.getChassisIdSubtypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ChassisIdSubtype readChassisIdSubtype() throws UaException {
        try {
            return this.readChassisIdSubtypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeChassisIdSubtype(ChassisIdSubtype value) throws UaException {
        try {
            this.writeChassisIdSubtypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ChassisIdSubtype> readChassisIdSubtypeAsync() {
        return ((CompletableFuture)this.getChassisIdSubtypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ChassisIdSubtype.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeChassisIdSubtypeAsync(ChassisIdSubtype chassisIdSubtype) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)chassisIdSubtype));
        return this.getChassisIdSubtypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getChassisIdSubtypeNode() throws UaException {
        try {
            return this.getChassisIdSubtypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getChassisIdSubtypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ChassisIdSubtype", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getChassisId() throws UaException {
        BaseDataVariableTypeNode node = this.getChassisIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setChassisId(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getChassisIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readChassisId() throws UaException {
        try {
            return this.readChassisIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeChassisId(String value) throws UaException {
        try {
            this.writeChassisIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readChassisIdAsync() {
        return ((CompletableFuture)this.getChassisIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeChassisIdAsync(String chassisId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)chassisId));
        return this.getChassisIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getChassisIdNode() throws UaException {
        try {
            return this.getChassisIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getChassisIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ChassisId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public PortIdSubtype getPortIdSubtype() throws UaException {
        BaseDataVariableTypeNode node = this.getPortIdSubtypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return PortIdSubtype.from((int)((Integer)value));
        }
        if (value instanceof PortIdSubtype) {
            return (PortIdSubtype)value;
        }
        return null;
    }

    @Override
    public void setPortIdSubtype(PortIdSubtype value) throws UaException {
        BaseDataVariableTypeNode node = this.getPortIdSubtypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public PortIdSubtype readPortIdSubtype() throws UaException {
        try {
            return this.readPortIdSubtypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortIdSubtype(PortIdSubtype value) throws UaException {
        try {
            this.writePortIdSubtypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends PortIdSubtype> readPortIdSubtypeAsync() {
        return ((CompletableFuture)this.getPortIdSubtypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return PortIdSubtype.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writePortIdSubtypeAsync(PortIdSubtype portIdSubtype) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portIdSubtype));
        return this.getPortIdSubtypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPortIdSubtypeNode() throws UaException {
        try {
            return this.getPortIdSubtypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPortIdSubtypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortIdSubtype", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getPortId() throws UaException {
        BaseDataVariableTypeNode node = this.getPortIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPortId(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getPortIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPortId() throws UaException {
        try {
            return this.readPortIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortId(String value) throws UaException {
        try {
            this.writePortIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPortIdAsync() {
        return ((CompletableFuture)this.getPortIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePortIdAsync(String portId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portId));
        return this.getPortIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPortIdNode() throws UaException {
        try {
            return this.getPortIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPortIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getPortDescription() throws UaException {
        BaseDataVariableTypeNode node = this.getPortDescriptionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPortDescription(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getPortDescriptionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPortDescription() throws UaException {
        try {
            return this.readPortDescriptionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortDescription(String value) throws UaException {
        try {
            this.writePortDescriptionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPortDescriptionAsync() {
        return ((CompletableFuture)this.getPortDescriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePortDescriptionAsync(String portDescription) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portDescription));
        return this.getPortDescriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPortDescriptionNode() throws UaException {
        try {
            return this.getPortDescriptionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPortDescriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortDescription", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSystemName() throws UaException {
        BaseDataVariableTypeNode node = this.getSystemNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemName(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getSystemNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSystemName() throws UaException {
        try {
            return this.readSystemNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemName(String value) throws UaException {
        try {
            this.writeSystemNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSystemNameAsync() {
        return ((CompletableFuture)this.getSystemNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemNameAsync(String systemName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemName));
        return this.getSystemNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSystemNameNode() throws UaException {
        try {
            return this.getSystemNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSystemNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemName", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSystemDescription() throws UaException {
        BaseDataVariableTypeNode node = this.getSystemDescriptionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemDescription(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getSystemDescriptionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSystemDescription() throws UaException {
        try {
            return this.readSystemDescriptionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemDescription(String value) throws UaException {
        try {
            this.writeSystemDescriptionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSystemDescriptionAsync() {
        return ((CompletableFuture)this.getSystemDescriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemDescriptionAsync(String systemDescription) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemDescription));
        return this.getSystemDescriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSystemDescriptionNode() throws UaException {
        try {
            return this.getSystemDescriptionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSystemDescriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemDescription", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() throws UaException {
        BaseDataVariableTypeNode node = this.getSystemCapabilitiesSupportedNode();
        return (LldpSystemCapabilitiesMap)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap value) throws UaException {
        BaseDataVariableTypeNode node = this.getSystemCapabilitiesSupportedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LldpSystemCapabilitiesMap readSystemCapabilitiesSupported() throws UaException {
        try {
            return this.readSystemCapabilitiesSupportedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemCapabilitiesSupported(LldpSystemCapabilitiesMap value) throws UaException {
        try {
            this.writeSystemCapabilitiesSupportedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpSystemCapabilitiesMap> readSystemCapabilitiesSupportedAsync() {
        return ((CompletableFuture)this.getSystemCapabilitiesSupportedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LldpSystemCapabilitiesMap)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemCapabilitiesSupportedAsync(LldpSystemCapabilitiesMap systemCapabilitiesSupported) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemCapabilitiesSupported));
        return this.getSystemCapabilitiesSupportedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSystemCapabilitiesSupportedNode() throws UaException {
        try {
            return this.getSystemCapabilitiesSupportedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSystemCapabilitiesSupportedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() throws UaException {
        BaseDataVariableTypeNode node = this.getSystemCapabilitiesEnabledNode();
        return (LldpSystemCapabilitiesMap)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap value) throws UaException {
        BaseDataVariableTypeNode node = this.getSystemCapabilitiesEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LldpSystemCapabilitiesMap readSystemCapabilitiesEnabled() throws UaException {
        try {
            return this.readSystemCapabilitiesEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap value) throws UaException {
        try {
            this.writeSystemCapabilitiesEnabledAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpSystemCapabilitiesMap> readSystemCapabilitiesEnabledAsync() {
        return ((CompletableFuture)this.getSystemCapabilitiesEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LldpSystemCapabilitiesMap)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemCapabilitiesEnabledAsync(LldpSystemCapabilitiesMap systemCapabilitiesEnabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemCapabilitiesEnabled));
        return this.getSystemCapabilitiesEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSystemCapabilitiesEnabledNode() throws UaException {
        try {
            return this.getSystemCapabilitiesEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSystemCapabilitiesEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Boolean getRemoteChanges() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteChangesNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteChanges(Boolean value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteChangesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readRemoteChanges() throws UaException {
        try {
            return this.readRemoteChangesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteChanges(Boolean value) throws UaException {
        try {
            this.writeRemoteChangesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readRemoteChangesAsync() {
        return ((CompletableFuture)this.getRemoteChangesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteChangesAsync(Boolean remoteChanges) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteChanges));
        return this.getRemoteChangesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteChangesNode() throws UaException {
        try {
            return this.getRemoteChangesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteChangesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteChanges", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Boolean getRemoteTooManyNeighbors() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteTooManyNeighborsNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteTooManyNeighbors(Boolean value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteTooManyNeighborsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readRemoteTooManyNeighbors() throws UaException {
        try {
            return this.readRemoteTooManyNeighborsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteTooManyNeighbors(Boolean value) throws UaException {
        try {
            this.writeRemoteTooManyNeighborsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readRemoteTooManyNeighborsAsync() {
        return ((CompletableFuture)this.getRemoteTooManyNeighborsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteTooManyNeighborsAsync(Boolean remoteTooManyNeighbors) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteTooManyNeighbors));
        return this.getRemoteTooManyNeighborsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteTooManyNeighborsNode() throws UaException {
        try {
            return this.getRemoteTooManyNeighborsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteTooManyNeighborsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteTooManyNeighbors", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public LldpManagementAddressType[] getManagementAddress() throws UaException {
        BaseDataVariableTypeNode node = this.getManagementAddressNode();
        return this.cast(node.getValue().getValue().getValue(), LldpManagementAddressType[].class);
    }

    @Override
    public void setManagementAddress(LldpManagementAddressType[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getManagementAddressNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public LldpManagementAddressType[] readManagementAddress() throws UaException {
        try {
            return this.readManagementAddressAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeManagementAddress(LldpManagementAddressType[] value) throws UaException {
        try {
            this.writeManagementAddressAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpManagementAddressType[]> readManagementAddressAsync() {
        return ((CompletableFuture)this.getManagementAddressNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), LldpManagementAddressType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeManagementAddressAsync(LldpManagementAddressType[] managementAddress) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])managementAddress);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getManagementAddressNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getManagementAddressNode() throws UaException {
        try {
            return this.getManagementAddressNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getManagementAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ManagementAddress", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public LldpTlvType[] getRemoteUnknownTlv() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteUnknownTlvNode();
        return this.cast(node.getValue().getValue().getValue(), LldpTlvType[].class);
    }

    @Override
    public void setRemoteUnknownTlv(LldpTlvType[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteUnknownTlvNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public LldpTlvType[] readRemoteUnknownTlv() throws UaException {
        try {
            return this.readRemoteUnknownTlvAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteUnknownTlv(LldpTlvType[] value) throws UaException {
        try {
            this.writeRemoteUnknownTlvAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpTlvType[]> readRemoteUnknownTlvAsync() {
        return ((CompletableFuture)this.getRemoteUnknownTlvNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), LldpTlvType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteUnknownTlvAsync(LldpTlvType[] remoteUnknownTlv) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])remoteUnknownTlv);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getRemoteUnknownTlvNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteUnknownTlvNode() throws UaException {
        try {
            return this.getRemoteUnknownTlvNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteUnknownTlvNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteUnknownTlv", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

