/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LldpRemoteStatisticsType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class LldpRemoteStatisticsTypeNode
extends BaseObjectTypeNode
implements LldpRemoteStatisticsType {
    public LldpRemoteStatisticsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getLastChangeTime() throws UaException {
        BaseDataVariableTypeNode node = this.getLastChangeTimeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastChangeTime(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getLastChangeTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readLastChangeTime() throws UaException {
        try {
            return this.readLastChangeTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastChangeTime(UInteger value) throws UaException {
        try {
            this.writeLastChangeTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readLastChangeTimeAsync() {
        return ((CompletableFuture)this.getLastChangeTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastChangeTimeAsync(UInteger lastChangeTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastChangeTime));
        return this.getLastChangeTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLastChangeTimeNode() throws UaException {
        try {
            return this.getLastChangeTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLastChangeTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastChangeTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRemoteInserts() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteInsertsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteInserts(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteInsertsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRemoteInserts() throws UaException {
        try {
            return this.readRemoteInsertsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteInserts(UInteger value) throws UaException {
        try {
            this.writeRemoteInsertsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRemoteInsertsAsync() {
        return ((CompletableFuture)this.getRemoteInsertsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteInsertsAsync(UInteger remoteInserts) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteInserts));
        return this.getRemoteInsertsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteInsertsNode() throws UaException {
        try {
            return this.getRemoteInsertsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteInsertsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteInserts", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRemoteDeletes() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteDeletesNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteDeletes(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteDeletesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRemoteDeletes() throws UaException {
        try {
            return this.readRemoteDeletesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteDeletes(UInteger value) throws UaException {
        try {
            this.writeRemoteDeletesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRemoteDeletesAsync() {
        return ((CompletableFuture)this.getRemoteDeletesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteDeletesAsync(UInteger remoteDeletes) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteDeletes));
        return this.getRemoteDeletesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteDeletesNode() throws UaException {
        try {
            return this.getRemoteDeletesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteDeletesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteDeletes", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRemoteDrops() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteDropsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteDrops(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteDropsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRemoteDrops() throws UaException {
        try {
            return this.readRemoteDropsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteDrops(UInteger value) throws UaException {
        try {
            this.writeRemoteDropsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRemoteDropsAsync() {
        return ((CompletableFuture)this.getRemoteDropsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteDropsAsync(UInteger remoteDrops) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteDrops));
        return this.getRemoteDropsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteDropsNode() throws UaException {
        try {
            return this.getRemoteDropsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteDropsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteDrops", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getRemoteAgeouts() throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteAgeoutsNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setRemoteAgeouts(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getRemoteAgeoutsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readRemoteAgeouts() throws UaException {
        try {
            return this.readRemoteAgeoutsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRemoteAgeouts(UInteger value) throws UaException {
        try {
            this.writeRemoteAgeoutsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readRemoteAgeoutsAsync() {
        return ((CompletableFuture)this.getRemoteAgeoutsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRemoteAgeoutsAsync(UInteger remoteAgeouts) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)remoteAgeouts));
        return this.getRemoteAgeoutsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRemoteAgeoutsNode() throws UaException {
        try {
            return this.getRemoteAgeoutsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRemoteAgeoutsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteAgeouts", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

