/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LldpPortInformationType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PortIdSubtype;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.LldpManagementAddressTxPortType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class LldpPortInformationTypeNode
extends BaseObjectTypeNode
implements LldpPortInformationType {
    public LldpPortInformationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getIetfBaseNetworkInterfaceName() throws UaException {
        PropertyTypeNode node = this.getIetfBaseNetworkInterfaceNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setIetfBaseNetworkInterfaceName(String value) throws UaException {
        PropertyTypeNode node = this.getIetfBaseNetworkInterfaceNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readIetfBaseNetworkInterfaceName() throws UaException {
        try {
            return this.readIetfBaseNetworkInterfaceNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeIetfBaseNetworkInterfaceName(String value) throws UaException {
        try {
            this.writeIetfBaseNetworkInterfaceNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readIetfBaseNetworkInterfaceNameAsync() {
        return ((CompletableFuture)this.getIetfBaseNetworkInterfaceNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeIetfBaseNetworkInterfaceNameAsync(String ietfBaseNetworkInterfaceName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)ietfBaseNetworkInterfaceName));
        return this.getIetfBaseNetworkInterfaceNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getIetfBaseNetworkInterfaceNameNode() throws UaException {
        try {
            return this.getIetfBaseNetworkInterfaceNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getIetfBaseNetworkInterfaceNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "IetfBaseNetworkInterfaceName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UByte[] getDestMacAddress() throws UaException {
        PropertyTypeNode node = this.getDestMacAddressNode();
        return (UByte[])node.getValue().getValue().getValue();
    }

    @Override
    public void setDestMacAddress(UByte[] value) throws UaException {
        PropertyTypeNode node = this.getDestMacAddressNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte[] readDestMacAddress() throws UaException {
        try {
            return this.readDestMacAddressAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDestMacAddress(UByte[] value) throws UaException {
        try {
            this.writeDestMacAddressAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte[]> readDestMacAddressAsync() {
        return ((CompletableFuture)this.getDestMacAddressNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeDestMacAddressAsync(UByte[] destMacAddress) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)destMacAddress));
        return this.getDestMacAddressNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDestMacAddressNode() throws UaException {
        try {
            return this.getDestMacAddressNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDestMacAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DestMacAddress", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public PortIdSubtype getPortIdSubtype() throws UaException {
        PropertyTypeNode node = this.getPortIdSubtypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return PortIdSubtype.from((int)((Integer)value));
        }
        if (value instanceof PortIdSubtype) {
            return (PortIdSubtype)value;
        }
        return null;
    }

    @Override
    public void setPortIdSubtype(PortIdSubtype value) throws UaException {
        PropertyTypeNode node = this.getPortIdSubtypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public PortIdSubtype readPortIdSubtype() throws UaException {
        try {
            return this.readPortIdSubtypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortIdSubtype(PortIdSubtype value) throws UaException {
        try {
            this.writePortIdSubtypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends PortIdSubtype> readPortIdSubtypeAsync() {
        return ((CompletableFuture)this.getPortIdSubtypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return PortIdSubtype.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writePortIdSubtypeAsync(PortIdSubtype portIdSubtype) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portIdSubtype));
        return this.getPortIdSubtypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPortIdSubtypeNode() throws UaException {
        try {
            return this.getPortIdSubtypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPortIdSubtypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortIdSubtype", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getPortId() throws UaException {
        PropertyTypeNode node = this.getPortIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPortId(String value) throws UaException {
        PropertyTypeNode node = this.getPortIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPortId() throws UaException {
        try {
            return this.readPortIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortId(String value) throws UaException {
        try {
            this.writePortIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPortIdAsync() {
        return ((CompletableFuture)this.getPortIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePortIdAsync(String portId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portId));
        return this.getPortIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPortIdNode() throws UaException {
        try {
            return this.getPortIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPortIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getPortDescription() throws UaException {
        PropertyTypeNode node = this.getPortDescriptionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPortDescription(String value) throws UaException {
        PropertyTypeNode node = this.getPortDescriptionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPortDescription() throws UaException {
        try {
            return this.readPortDescriptionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePortDescription(String value) throws UaException {
        try {
            this.writePortDescriptionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPortDescriptionAsync() {
        return ((CompletableFuture)this.getPortDescriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePortDescriptionAsync(String portDescription) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)portDescription));
        return this.getPortDescriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPortDescriptionNode() throws UaException {
        try {
            return this.getPortDescriptionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPortDescriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PortDescription", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LldpManagementAddressTxPortType[] getManagementAddressTxPort() throws UaException {
        PropertyTypeNode node = this.getManagementAddressTxPortNode();
        return this.cast(node.getValue().getValue().getValue(), LldpManagementAddressTxPortType[].class);
    }

    @Override
    public void setManagementAddressTxPort(LldpManagementAddressTxPortType[] value) throws UaException {
        PropertyTypeNode node = this.getManagementAddressTxPortNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public LldpManagementAddressTxPortType[] readManagementAddressTxPort() throws UaException {
        try {
            return this.readManagementAddressTxPortAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeManagementAddressTxPort(LldpManagementAddressTxPortType[] value) throws UaException {
        try {
            this.writeManagementAddressTxPortAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpManagementAddressTxPortType[]> readManagementAddressTxPortAsync() {
        return ((CompletableFuture)this.getManagementAddressTxPortNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), LldpManagementAddressTxPortType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeManagementAddressTxPortAsync(LldpManagementAddressTxPortType[] managementAddressTxPort) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])managementAddressTxPort);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getManagementAddressTxPortNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getManagementAddressTxPortNode() throws UaException {
        try {
            return this.getManagementAddressTxPortNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getManagementAddressTxPortNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ManagementAddressTxPort", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public FolderTypeNode getRemoteSystemsDataNode() throws UaException {
        try {
            return this.getRemoteSystemsDataNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getRemoteSystemsDataNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RemoteSystemsData", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

