/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LldpLocalSystemType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ChassisIdSubtype;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.LldpSystemCapabilitiesMap;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class LldpLocalSystemTypeNode
extends BaseObjectTypeNode
implements LldpLocalSystemType {
    public LldpLocalSystemTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ChassisIdSubtype getChassisIdSubtype() throws UaException {
        PropertyTypeNode node = this.getChassisIdSubtypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ChassisIdSubtype.from((int)((Integer)value));
        }
        if (value instanceof ChassisIdSubtype) {
            return (ChassisIdSubtype)value;
        }
        return null;
    }

    @Override
    public void setChassisIdSubtype(ChassisIdSubtype value) throws UaException {
        PropertyTypeNode node = this.getChassisIdSubtypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ChassisIdSubtype readChassisIdSubtype() throws UaException {
        try {
            return this.readChassisIdSubtypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeChassisIdSubtype(ChassisIdSubtype value) throws UaException {
        try {
            this.writeChassisIdSubtypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ChassisIdSubtype> readChassisIdSubtypeAsync() {
        return ((CompletableFuture)this.getChassisIdSubtypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ChassisIdSubtype.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeChassisIdSubtypeAsync(ChassisIdSubtype chassisIdSubtype) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)chassisIdSubtype));
        return this.getChassisIdSubtypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getChassisIdSubtypeNode() throws UaException {
        try {
            return this.getChassisIdSubtypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getChassisIdSubtypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ChassisIdSubtype", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getChassisId() throws UaException {
        PropertyTypeNode node = this.getChassisIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setChassisId(String value) throws UaException {
        PropertyTypeNode node = this.getChassisIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readChassisId() throws UaException {
        try {
            return this.readChassisIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeChassisId(String value) throws UaException {
        try {
            this.writeChassisIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readChassisIdAsync() {
        return ((CompletableFuture)this.getChassisIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeChassisIdAsync(String chassisId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)chassisId));
        return this.getChassisIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getChassisIdNode() throws UaException {
        try {
            return this.getChassisIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getChassisIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ChassisId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSystemName() throws UaException {
        PropertyTypeNode node = this.getSystemNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemName(String value) throws UaException {
        PropertyTypeNode node = this.getSystemNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSystemName() throws UaException {
        try {
            return this.readSystemNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemName(String value) throws UaException {
        try {
            this.writeSystemNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSystemNameAsync() {
        return ((CompletableFuture)this.getSystemNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemNameAsync(String systemName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemName));
        return this.getSystemNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSystemNameNode() throws UaException {
        try {
            return this.getSystemNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSystemNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSystemDescription() throws UaException {
        PropertyTypeNode node = this.getSystemDescriptionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemDescription(String value) throws UaException {
        PropertyTypeNode node = this.getSystemDescriptionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSystemDescription() throws UaException {
        try {
            return this.readSystemDescriptionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemDescription(String value) throws UaException {
        try {
            this.writeSystemDescriptionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSystemDescriptionAsync() {
        return ((CompletableFuture)this.getSystemDescriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemDescriptionAsync(String systemDescription) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemDescription));
        return this.getSystemDescriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSystemDescriptionNode() throws UaException {
        try {
            return this.getSystemDescriptionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSystemDescriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemDescription", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() throws UaException {
        PropertyTypeNode node = this.getSystemCapabilitiesSupportedNode();
        return (LldpSystemCapabilitiesMap)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap value) throws UaException {
        PropertyTypeNode node = this.getSystemCapabilitiesSupportedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LldpSystemCapabilitiesMap readSystemCapabilitiesSupported() throws UaException {
        try {
            return this.readSystemCapabilitiesSupportedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemCapabilitiesSupported(LldpSystemCapabilitiesMap value) throws UaException {
        try {
            this.writeSystemCapabilitiesSupportedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpSystemCapabilitiesMap> readSystemCapabilitiesSupportedAsync() {
        return ((CompletableFuture)this.getSystemCapabilitiesSupportedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LldpSystemCapabilitiesMap)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemCapabilitiesSupportedAsync(LldpSystemCapabilitiesMap systemCapabilitiesSupported) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemCapabilitiesSupported));
        return this.getSystemCapabilitiesSupportedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSystemCapabilitiesSupportedNode() throws UaException {
        try {
            return this.getSystemCapabilitiesSupportedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSystemCapabilitiesSupportedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() throws UaException {
        PropertyTypeNode node = this.getSystemCapabilitiesEnabledNode();
        return (LldpSystemCapabilitiesMap)node.getValue().getValue().getValue();
    }

    @Override
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap value) throws UaException {
        PropertyTypeNode node = this.getSystemCapabilitiesEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LldpSystemCapabilitiesMap readSystemCapabilitiesEnabled() throws UaException {
        try {
            return this.readSystemCapabilitiesEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap value) throws UaException {
        try {
            this.writeSystemCapabilitiesEnabledAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LldpSystemCapabilitiesMap> readSystemCapabilitiesEnabledAsync() {
        return ((CompletableFuture)this.getSystemCapabilitiesEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LldpSystemCapabilitiesMap)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSystemCapabilitiesEnabledAsync(LldpSystemCapabilitiesMap systemCapabilitiesEnabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)systemCapabilitiesEnabled));
        return this.getSystemCapabilitiesEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSystemCapabilitiesEnabledNode() throws UaException {
        try {
            return this.getSystemCapabilitiesEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSystemCapabilitiesEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

