/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.KeyCredentialConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class KeyCredentialConfigurationTypeNode
extends BaseObjectTypeNode
implements KeyCredentialConfigurationType {
    public KeyCredentialConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getResourceUri() throws UaException {
        PropertyTypeNode node = this.getResourceUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setResourceUri(String value) throws UaException {
        PropertyTypeNode node = this.getResourceUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readResourceUri() throws UaException {
        try {
            return this.readResourceUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeResourceUri(String value) throws UaException {
        try {
            this.writeResourceUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readResourceUriAsync() {
        return ((CompletableFuture)this.getResourceUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeResourceUriAsync(String resourceUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)resourceUri));
        return this.getResourceUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getResourceUriNode() throws UaException {
        try {
            return this.getResourceUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getResourceUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ResourceUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getProfileUri() throws UaException {
        PropertyTypeNode node = this.getProfileUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProfileUri(String value) throws UaException {
        PropertyTypeNode node = this.getProfileUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readProfileUri() throws UaException {
        try {
            return this.readProfileUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProfileUri(String value) throws UaException {
        try {
            this.writeProfileUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readProfileUriAsync() {
        return ((CompletableFuture)this.getProfileUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProfileUriAsync(String profileUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)profileUri));
        return this.getProfileUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getProfileUriNode() throws UaException {
        try {
            return this.getProfileUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getProfileUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProfileUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String[] getEndpointUrls() throws UaException {
        PropertyTypeNode node = this.getEndpointUrlsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setEndpointUrls(String[] value) throws UaException {
        PropertyTypeNode node = this.getEndpointUrlsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String[] readEndpointUrls() throws UaException {
        try {
            return this.readEndpointUrlsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEndpointUrls(String[] value) throws UaException {
        try {
            this.writeEndpointUrlsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readEndpointUrlsAsync() {
        return ((CompletableFuture)this.getEndpointUrlsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEndpointUrlsAsync(String[] endpointUrls) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)endpointUrls));
        return this.getEndpointUrlsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEndpointUrlsNode() throws UaException {
        try {
            return this.getEndpointUrlsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEndpointUrlsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EndpointUrls", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getCredentialId() throws UaException {
        PropertyTypeNode node = this.getCredentialIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setCredentialId(String value) throws UaException {
        PropertyTypeNode node = this.getCredentialIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readCredentialId() throws UaException {
        try {
            return this.readCredentialIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCredentialId(String value) throws UaException {
        try {
            this.writeCredentialIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readCredentialIdAsync() {
        return ((CompletableFuture)this.getCredentialIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCredentialIdAsync(String credentialId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)credentialId));
        return this.getCredentialIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCredentialIdNode() throws UaException {
        try {
            return this.getCredentialIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCredentialIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CredentialId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public StatusCode getServiceStatus() throws UaException {
        PropertyTypeNode node = this.getServiceStatusNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setServiceStatus(StatusCode value) throws UaException {
        PropertyTypeNode node = this.getServiceStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public StatusCode readServiceStatus() throws UaException {
        try {
            return this.readServiceStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServiceStatus(StatusCode value) throws UaException {
        try {
            this.writeServiceStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readServiceStatusAsync() {
        return ((CompletableFuture)this.getServiceStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServiceStatusAsync(StatusCode serviceStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serviceStatus));
        return this.getServiceStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServiceStatusNode() throws UaException {
        try {
            return this.getServiceStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServiceStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServiceStatus", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

