/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IetfBaseNetworkInterfaceType;
import org.eclipse.milo.opcua.sdk.client.model.variables.AnalogUnitTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.enumerated.InterfaceAdminStatus;
import org.eclipse.milo.opcua.stack.core.types.enumerated.InterfaceOperStatus;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IetfBaseNetworkInterfaceTypeNode
extends BaseObjectTypeNode
implements IetfBaseNetworkInterfaceType {
    public IetfBaseNetworkInterfaceTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public InterfaceAdminStatus getAdminStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getAdminStatusNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return InterfaceAdminStatus.from((int)((Integer)value));
        }
        if (value instanceof InterfaceAdminStatus) {
            return (InterfaceAdminStatus)value;
        }
        return null;
    }

    @Override
    public void setAdminStatus(InterfaceAdminStatus value) throws UaException {
        BaseDataVariableTypeNode node = this.getAdminStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public InterfaceAdminStatus readAdminStatus() throws UaException {
        try {
            return this.readAdminStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAdminStatus(InterfaceAdminStatus value) throws UaException {
        try {
            this.writeAdminStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends InterfaceAdminStatus> readAdminStatusAsync() {
        return ((CompletableFuture)this.getAdminStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return InterfaceAdminStatus.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeAdminStatusAsync(InterfaceAdminStatus adminStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)adminStatus));
        return this.getAdminStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAdminStatusNode() throws UaException {
        try {
            return this.getAdminStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAdminStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AdminStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public InterfaceOperStatus getOperStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getOperStatusNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return InterfaceOperStatus.from((int)((Integer)value));
        }
        if (value instanceof InterfaceOperStatus) {
            return (InterfaceOperStatus)value;
        }
        return null;
    }

    @Override
    public void setOperStatus(InterfaceOperStatus value) throws UaException {
        BaseDataVariableTypeNode node = this.getOperStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public InterfaceOperStatus readOperStatus() throws UaException {
        try {
            return this.readOperStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOperStatus(InterfaceOperStatus value) throws UaException {
        try {
            this.writeOperStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends InterfaceOperStatus> readOperStatusAsync() {
        return ((CompletableFuture)this.getOperStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return InterfaceOperStatus.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeOperStatusAsync(InterfaceOperStatus operStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)operStatus));
        return this.getOperStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getOperStatusNode() throws UaException {
        try {
            return this.getOperStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getOperStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OperStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getPhysAddress() throws UaException {
        BaseDataVariableTypeNode node = this.getPhysAddressNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPhysAddress(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getPhysAddressNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPhysAddress() throws UaException {
        try {
            return this.readPhysAddressAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePhysAddress(String value) throws UaException {
        try {
            this.writePhysAddressAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPhysAddressAsync() {
        return ((CompletableFuture)this.getPhysAddressNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePhysAddressAsync(String physAddress) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)physAddress));
        return this.getPhysAddressNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPhysAddressNode() throws UaException {
        try {
            return this.getPhysAddressNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPhysAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PhysAddress", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ULong getSpeed() throws UaException {
        AnalogUnitTypeNode node = this.getSpeedNode();
        return (ULong)node.getValue().getValue().getValue();
    }

    @Override
    public void setSpeed(ULong value) throws UaException {
        AnalogUnitTypeNode node = this.getSpeedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ULong readSpeed() throws UaException {
        try {
            return this.readSpeedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSpeed(ULong value) throws UaException {
        try {
            this.writeSpeedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ULong> readSpeedAsync() {
        return ((CompletableFuture)this.getSpeedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ULong)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSpeedAsync(ULong speed) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)speed));
        return this.getSpeedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AnalogUnitTypeNode getSpeedNode() throws UaException {
        try {
            return this.getSpeedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AnalogUnitTypeNode> getSpeedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Speed", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AnalogUnitTypeNode)node);
    }
}

