/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ISrClassType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ISrClassTypeNode
extends BaseInterfaceTypeNode
implements ISrClassType {
    public ISrClassTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UByte getId() throws UaException {
        BaseDataVariableTypeNode node = this.getIdNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setId(UByte value) throws UaException {
        BaseDataVariableTypeNode node = this.getIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readId() throws UaException {
        try {
            return this.readIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeId(UByte value) throws UaException {
        try {
            this.writeIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readIdAsync() {
        return ((CompletableFuture)this.getIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeIdAsync(UByte id) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)id));
        return this.getIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getIdNode() throws UaException {
        try {
            return this.getIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Id", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UByte getPriority() throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriority(UByte value) throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPriority() throws UaException {
        try {
            return this.readPriorityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriority(UByte value) throws UaException {
        try {
            this.writePriorityAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPriorityAsync() {
        return ((CompletableFuture)this.getPriorityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityAsync(UByte priority) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priority));
        return this.getPriorityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPriorityNode() throws UaException {
        try {
            return this.getPriorityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPriorityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Priority", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UShort getVid() throws UaException {
        BaseDataVariableTypeNode node = this.getVidNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setVid(UShort value) throws UaException {
        BaseDataVariableTypeNode node = this.getVidNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readVid() throws UaException {
        try {
            return this.readVidAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeVid(UShort value) throws UaException {
        try {
            this.writeVidAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readVidAsync() {
        return ((CompletableFuture)this.getVidNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeVidAsync(UShort vid) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)vid));
        return this.getVidNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getVidNode() throws UaException {
        try {
            return this.getVidNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getVidNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Vid", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

