/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IPriorityMappingEntryType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IPriorityMappingEntryTypeNode
extends BaseInterfaceTypeNode
implements IPriorityMappingEntryType {
    public IPriorityMappingEntryTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getMappingUri() throws UaException {
        BaseDataVariableTypeNode node = this.getMappingUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setMappingUri(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getMappingUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readMappingUri() throws UaException {
        try {
            return this.readMappingUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMappingUri(String value) throws UaException {
        try {
            this.writeMappingUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readMappingUriAsync() {
        return ((CompletableFuture)this.getMappingUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMappingUriAsync(String mappingUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)mappingUri));
        return this.getMappingUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMappingUriNode() throws UaException {
        try {
            return this.getMappingUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMappingUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MappingUri", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getPriorityLabel() throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityLabelNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriorityLabel(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityLabelNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readPriorityLabel() throws UaException {
        try {
            return this.readPriorityLabelAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriorityLabel(String value) throws UaException {
        try {
            this.writePriorityLabelAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readPriorityLabelAsync() {
        return ((CompletableFuture)this.getPriorityLabelNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityLabelAsync(String priorityLabel) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priorityLabel));
        return this.getPriorityLabelNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPriorityLabelNode() throws UaException {
        try {
            return this.getPriorityLabelNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPriorityLabelNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PriorityLabel", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UByte getPriorityValuePcp() throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityValuePcpNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriorityValuePcp(UByte value) throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityValuePcpNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readPriorityValuePcp() throws UaException {
        try {
            return this.readPriorityValuePcpAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriorityValuePcp(UByte value) throws UaException {
        try {
            this.writePriorityValuePcpAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readPriorityValuePcpAsync() {
        return ((CompletableFuture)this.getPriorityValuePcpNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityValuePcpAsync(UByte priorityValuePcp) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priorityValuePcp));
        return this.getPriorityValuePcpNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPriorityValuePcpNode() throws UaException {
        try {
            return this.getPriorityValuePcpNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPriorityValuePcpNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PriorityValue_PCP", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getPriorityValueDscp() throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityValueDscpNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setPriorityValueDscp(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getPriorityValueDscpNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readPriorityValueDscp() throws UaException {
        try {
            return this.readPriorityValueDscpAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePriorityValueDscp(UInteger value) throws UaException {
        try {
            this.writePriorityValueDscpAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readPriorityValueDscpAsync() {
        return ((CompletableFuture)this.getPriorityValueDscpNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writePriorityValueDscpAsync(UInteger priorityValueDscp) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)priorityValueDscp));
        return this.getPriorityValueDscpNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPriorityValueDscpNode() throws UaException {
        try {
            return this.getPriorityValueDscpNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPriorityValueDscpNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PriorityValue_DSCP", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

