/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IIeeeBaseTsnStreamType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TsnStreamState;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IIeeeBaseTsnStreamTypeNode
extends BaseInterfaceTypeNode
implements IIeeeBaseTsnStreamType {
    public IIeeeBaseTsnStreamTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UByte[] getStreamId() throws UaException {
        BaseDataVariableTypeNode node = this.getStreamIdNode();
        return (UByte[])node.getValue().getValue().getValue();
    }

    @Override
    public void setStreamId(UByte[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getStreamIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte[] readStreamId() throws UaException {
        try {
            return this.readStreamIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStreamId(UByte[] value) throws UaException {
        try {
            this.writeStreamIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte[]> readStreamIdAsync() {
        return ((CompletableFuture)this.getStreamIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStreamIdAsync(UByte[] streamId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)streamId));
        return this.getStreamIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStreamIdNode() throws UaException {
        try {
            return this.getStreamIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStreamIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StreamId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getStreamName() throws UaException {
        BaseDataVariableTypeNode node = this.getStreamNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setStreamName(String value) throws UaException {
        BaseDataVariableTypeNode node = this.getStreamNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readStreamName() throws UaException {
        try {
            return this.readStreamNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStreamName(String value) throws UaException {
        try {
            this.writeStreamNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readStreamNameAsync() {
        return ((CompletableFuture)this.getStreamNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStreamNameAsync(String streamName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)streamName));
        return this.getStreamNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStreamNameNode() throws UaException {
        try {
            return this.getStreamNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStreamNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StreamName", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public TsnStreamState getState() throws UaException {
        BaseDataVariableTypeNode node = this.getStateNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return TsnStreamState.from((int)((Integer)value));
        }
        if (value instanceof TsnStreamState) {
            return (TsnStreamState)value;
        }
        return null;
    }

    @Override
    public void setState(TsnStreamState value) throws UaException {
        BaseDataVariableTypeNode node = this.getStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public TsnStreamState readState() throws UaException {
        try {
            return this.readStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeState(TsnStreamState value) throws UaException {
        try {
            this.writeStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TsnStreamState> readStateAsync() {
        return ((CompletableFuture)this.getStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return TsnStreamState.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeStateAsync(TsnStreamState state) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)state));
        return this.getStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStateNode() throws UaException {
        try {
            return this.getStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "State", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getAccumulatedLatency() throws UaException {
        BaseDataVariableTypeNode node = this.getAccumulatedLatencyNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setAccumulatedLatency(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getAccumulatedLatencyNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readAccumulatedLatency() throws UaException {
        try {
            return this.readAccumulatedLatencyAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAccumulatedLatency(UInteger value) throws UaException {
        try {
            this.writeAccumulatedLatencyAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readAccumulatedLatencyAsync() {
        return ((CompletableFuture)this.getAccumulatedLatencyNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAccumulatedLatencyAsync(UInteger accumulatedLatency) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)accumulatedLatency));
        return this.getAccumulatedLatencyNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAccumulatedLatencyNode() throws UaException {
        try {
            return this.getAccumulatedLatencyNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAccumulatedLatencyNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AccumulatedLatency", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UByte getSrClassId() throws UaException {
        BaseDataVariableTypeNode node = this.getSrClassIdNode();
        return (UByte)node.getValue().getValue().getValue();
    }

    @Override
    public void setSrClassId(UByte value) throws UaException {
        BaseDataVariableTypeNode node = this.getSrClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UByte readSrClassId() throws UaException {
        try {
            return this.readSrClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSrClassId(UByte value) throws UaException {
        try {
            this.writeSrClassIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UByte> readSrClassIdAsync() {
        return ((CompletableFuture)this.getSrClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UByte)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSrClassIdAsync(UByte srClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)srClassId));
        return this.getSrClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSrClassIdNode() throws UaException {
        try {
            return this.getSrClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSrClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SrClassId", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

