/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IIeeeBaseTsnStatusStreamType;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TsnFailureCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TsnListenerStatus;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TsnTalkerStatus;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IIeeeBaseTsnStatusStreamTypeNode
extends BaseInterfaceTypeNode
implements IIeeeBaseTsnStatusStreamType {
    public IIeeeBaseTsnStatusStreamTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public TsnTalkerStatus getTalkerStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getTalkerStatusNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return TsnTalkerStatus.from((int)((Integer)value));
        }
        if (value instanceof TsnTalkerStatus) {
            return (TsnTalkerStatus)value;
        }
        return null;
    }

    @Override
    public void setTalkerStatus(TsnTalkerStatus value) throws UaException {
        BaseDataVariableTypeNode node = this.getTalkerStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public TsnTalkerStatus readTalkerStatus() throws UaException {
        try {
            return this.readTalkerStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTalkerStatus(TsnTalkerStatus value) throws UaException {
        try {
            this.writeTalkerStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TsnTalkerStatus> readTalkerStatusAsync() {
        return ((CompletableFuture)this.getTalkerStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return TsnTalkerStatus.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeTalkerStatusAsync(TsnTalkerStatus talkerStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)talkerStatus));
        return this.getTalkerStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTalkerStatusNode() throws UaException {
        try {
            return this.getTalkerStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTalkerStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TalkerStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public TsnListenerStatus getListenerStatus() throws UaException {
        BaseDataVariableTypeNode node = this.getListenerStatusNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return TsnListenerStatus.from((int)((Integer)value));
        }
        if (value instanceof TsnListenerStatus) {
            return (TsnListenerStatus)value;
        }
        return null;
    }

    @Override
    public void setListenerStatus(TsnListenerStatus value) throws UaException {
        BaseDataVariableTypeNode node = this.getListenerStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public TsnListenerStatus readListenerStatus() throws UaException {
        try {
            return this.readListenerStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeListenerStatus(TsnListenerStatus value) throws UaException {
        try {
            this.writeListenerStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TsnListenerStatus> readListenerStatusAsync() {
        return ((CompletableFuture)this.getListenerStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return TsnListenerStatus.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeListenerStatusAsync(TsnListenerStatus listenerStatus) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)listenerStatus));
        return this.getListenerStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getListenerStatusNode() throws UaException {
        try {
            return this.getListenerStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getListenerStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ListenerStatus", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public TsnFailureCode getFailureCode() throws UaException {
        BaseDataVariableTypeNode node = this.getFailureCodeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return TsnFailureCode.from((int)((Integer)value));
        }
        if (value instanceof TsnFailureCode) {
            return (TsnFailureCode)value;
        }
        return null;
    }

    @Override
    public void setFailureCode(TsnFailureCode value) throws UaException {
        BaseDataVariableTypeNode node = this.getFailureCodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public TsnFailureCode readFailureCode() throws UaException {
        try {
            return this.readFailureCodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFailureCode(TsnFailureCode value) throws UaException {
        try {
            this.writeFailureCodeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends TsnFailureCode> readFailureCodeAsync() {
        return ((CompletableFuture)this.getFailureCodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return TsnFailureCode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeFailureCodeAsync(TsnFailureCode failureCode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)failureCode));
        return this.getFailureCodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getFailureCodeNode() throws UaException {
        try {
            return this.getFailureCodeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getFailureCodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FailureCode", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Object getFailureSystemIdentifier() throws UaException {
        BaseDataVariableTypeNode node = this.getFailureSystemIdentifierNode();
        return node.getValue().getValue().getValue();
    }

    @Override
    public void setFailureSystemIdentifier(Object value) throws UaException {
        BaseDataVariableTypeNode node = this.getFailureSystemIdentifierNode();
        node.setValue(new Variant(value));
    }

    @Override
    public Object readFailureSystemIdentifier() throws UaException {
        try {
            return this.readFailureSystemIdentifierAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFailureSystemIdentifier(Object value) throws UaException {
        try {
            this.writeFailureSystemIdentifierAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<?> readFailureSystemIdentifierAsync() {
        return ((CompletableFuture)this.getFailureSystemIdentifierNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeFailureSystemIdentifierAsync(Object failureSystemIdentifier) {
        DataValue value = DataValue.valueOnly((Variant)new Variant(failureSystemIdentifier));
        return this.getFailureSystemIdentifierNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getFailureSystemIdentifierNode() throws UaException {
        try {
            return this.getFailureSystemIdentifierNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getFailureSystemIdentifierNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FailureSystemIdentifier", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

