/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseInterfaceTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.IIeeeBaseEthernetPortType;
import org.eclipse.milo.opcua.sdk.client.model.variables.AnalogUnitTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.Duplex;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class IIeeeBaseEthernetPortTypeNode
extends BaseInterfaceTypeNode
implements IIeeeBaseEthernetPortType {
    public IIeeeBaseEthernetPortTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ULong getSpeed() throws UaException {
        AnalogUnitTypeNode node = this.getSpeedNode();
        return (ULong)node.getValue().getValue().getValue();
    }

    @Override
    public void setSpeed(ULong value) throws UaException {
        AnalogUnitTypeNode node = this.getSpeedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ULong readSpeed() throws UaException {
        try {
            return this.readSpeedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSpeed(ULong value) throws UaException {
        try {
            this.writeSpeedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ULong> readSpeedAsync() {
        return ((CompletableFuture)this.getSpeedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ULong)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSpeedAsync(ULong speed) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)speed));
        return this.getSpeedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AnalogUnitTypeNode getSpeedNode() throws UaException {
        try {
            return this.getSpeedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AnalogUnitTypeNode> getSpeedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Speed", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AnalogUnitTypeNode)node);
    }

    @Override
    public Duplex getDuplex() throws UaException {
        BaseDataVariableTypeNode node = this.getDuplexNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return Duplex.from((int)((Integer)value));
        }
        if (value instanceof Duplex) {
            return (Duplex)value;
        }
        return null;
    }

    @Override
    public void setDuplex(Duplex value) throws UaException {
        BaseDataVariableTypeNode node = this.getDuplexNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Duplex readDuplex() throws UaException {
        try {
            return this.readDuplexAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDuplex(Duplex value) throws UaException {
        try {
            this.writeDuplexAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Duplex> readDuplexAsync() {
        return ((CompletableFuture)this.getDuplexNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return Duplex.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeDuplexAsync(Duplex duplex) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)duplex));
        return this.getDuplexNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDuplexNode() throws UaException {
        try {
            return this.getDuplexNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDuplexNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Duplex", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UShort getMaxFrameLength() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxFrameLengthNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxFrameLength(UShort value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxFrameLengthNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readMaxFrameLength() throws UaException {
        try {
            return this.readMaxFrameLengthAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxFrameLength(UShort value) throws UaException {
        try {
            this.writeMaxFrameLengthAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readMaxFrameLengthAsync() {
        return ((CompletableFuture)this.getMaxFrameLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxFrameLengthAsync(UShort maxFrameLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxFrameLength));
        return this.getMaxFrameLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxFrameLengthNode() throws UaException {
        try {
            return this.getMaxFrameLengthNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxFrameLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxFrameLength", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

