/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FolderTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.HistoricalEventConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class HistoricalEventConfigurationTypeNode
extends BaseObjectTypeNode
implements HistoricalEventConfigurationType {
    public HistoricalEventConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public DateTime getStartOfArchive() throws UaException {
        PropertyTypeNode node = this.getStartOfArchiveNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartOfArchive(DateTime value) throws UaException {
        PropertyTypeNode node = this.getStartOfArchiveNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartOfArchive() throws UaException {
        try {
            return this.readStartOfArchiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStartOfArchive(DateTime value) throws UaException {
        try {
            this.writeStartOfArchiveAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartOfArchiveAsync() {
        return ((CompletableFuture)this.getStartOfArchiveNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartOfArchiveAsync(DateTime startOfArchive) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startOfArchive));
        return this.getStartOfArchiveNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStartOfArchiveNode() throws UaException {
        try {
            return this.getStartOfArchiveNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStartOfArchiveNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartOfArchive", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getStartOfOnlineArchive() throws UaException {
        PropertyTypeNode node = this.getStartOfOnlineArchiveNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartOfOnlineArchive(DateTime value) throws UaException {
        PropertyTypeNode node = this.getStartOfOnlineArchiveNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartOfOnlineArchive() throws UaException {
        try {
            return this.readStartOfOnlineArchiveAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStartOfOnlineArchive(DateTime value) throws UaException {
        try {
            this.writeStartOfOnlineArchiveAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartOfOnlineArchiveAsync() {
        return ((CompletableFuture)this.getStartOfOnlineArchiveNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartOfOnlineArchiveAsync(DateTime startOfOnlineArchive) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startOfOnlineArchive));
        return this.getStartOfOnlineArchiveNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStartOfOnlineArchiveNode() throws UaException {
        try {
            return this.getStartOfOnlineArchiveNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStartOfOnlineArchiveNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartOfOnlineArchive", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SimpleAttributeOperand[] getSortByEventFields() throws UaException {
        PropertyTypeNode node = this.getSortByEventFieldsNode();
        return this.cast(node.getValue().getValue().getValue(), SimpleAttributeOperand[].class);
    }

    @Override
    public void setSortByEventFields(SimpleAttributeOperand[] value) throws UaException {
        PropertyTypeNode node = this.getSortByEventFieldsNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public SimpleAttributeOperand[] readSortByEventFields() throws UaException {
        try {
            return this.readSortByEventFieldsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSortByEventFields(SimpleAttributeOperand[] value) throws UaException {
        try {
            this.writeSortByEventFieldsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SimpleAttributeOperand[]> readSortByEventFieldsAsync() {
        return ((CompletableFuture)this.getSortByEventFieldsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), SimpleAttributeOperand[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSortByEventFieldsAsync(SimpleAttributeOperand[] sortByEventFields) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])sortByEventFields);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSortByEventFieldsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSortByEventFieldsNode() throws UaException {
        try {
            return this.getSortByEventFieldsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSortByEventFieldsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SortByEventFields", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public FolderTypeNode getEventTypesNode() throws UaException {
        try {
            return this.getEventTypesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends FolderTypeNode> getEventTypesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EventTypes", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (FolderTypeNode)node);
    }
}

