/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.FiniteStateMachineType;
import org.eclipse.milo.opcua.sdk.client.model.objects.StateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.FiniteStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.FiniteTransitionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class FiniteStateMachineTypeNode
extends StateMachineTypeNode
implements FiniteStateMachineType {
    public FiniteStateMachineTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LocalizedText getCurrentState() throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentState(LocalizedText value) throws UaException {
        FiniteStateVariableTypeNode node = this.getCurrentStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readCurrentState() throws UaException {
        try {
            return this.readCurrentStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentState(LocalizedText value) throws UaException {
        try {
            this.writeCurrentStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCurrentStateAsync() {
        return ((CompletableFuture)this.getCurrentStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentStateAsync(LocalizedText currentState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentState));
        return this.getCurrentStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public FiniteStateVariableTypeNode getCurrentStateNode() throws UaException {
        try {
            return this.getCurrentStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends FiniteStateVariableTypeNode> getCurrentStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (FiniteStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getLastTransition() throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastTransition(LocalizedText value) throws UaException {
        FiniteTransitionVariableTypeNode node = this.getLastTransitionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readLastTransition() throws UaException {
        try {
            return this.readLastTransitionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastTransition(LocalizedText value) throws UaException {
        try {
            this.writeLastTransitionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLastTransitionAsync() {
        return ((CompletableFuture)this.getLastTransitionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastTransitionAsync(LocalizedText lastTransition) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastTransition));
        return this.getLastTransitionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public FiniteTransitionVariableTypeNode getLastTransitionNode() throws UaException {
        try {
            return this.getLastTransitionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends FiniteTransitionVariableTypeNode> getLastTransitionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastTransition", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (FiniteTransitionVariableTypeNode)node);
    }

    @Override
    public NodeId[] getAvailableStates() throws UaException {
        BaseDataVariableTypeNode node = this.getAvailableStatesNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setAvailableStates(NodeId[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getAvailableStatesNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readAvailableStates() throws UaException {
        try {
            return this.readAvailableStatesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAvailableStates(NodeId[] value) throws UaException {
        try {
            this.writeAvailableStatesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readAvailableStatesAsync() {
        return ((CompletableFuture)this.getAvailableStatesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAvailableStatesAsync(NodeId[] availableStates) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)availableStates));
        return this.getAvailableStatesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAvailableStatesNode() throws UaException {
        try {
            return this.getAvailableStatesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAvailableStatesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AvailableStates", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public NodeId[] getAvailableTransitions() throws UaException {
        BaseDataVariableTypeNode node = this.getAvailableTransitionsNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setAvailableTransitions(NodeId[] value) throws UaException {
        BaseDataVariableTypeNode node = this.getAvailableTransitionsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readAvailableTransitions() throws UaException {
        try {
            return this.readAvailableTransitionsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAvailableTransitions(NodeId[] value) throws UaException {
        try {
            this.writeAvailableTransitionsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readAvailableTransitionsAsync() {
        return ((CompletableFuture)this.getAvailableTransitionsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAvailableTransitionsAsync(NodeId[] availableTransitions) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)availableTransitions));
        return this.getAvailableTransitionsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAvailableTransitionsNode() throws UaException {
        try {
            return this.getAvailableTransitionsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAvailableTransitionsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AvailableTransitions", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

