/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.FileType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class FileTypeNode
extends BaseObjectTypeNode
implements FileType {
    public FileTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ULong getSize() throws UaException {
        PropertyTypeNode node = this.getSizeNode();
        return (ULong)node.getValue().getValue().getValue();
    }

    @Override
    public void setSize(ULong value) throws UaException {
        PropertyTypeNode node = this.getSizeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ULong readSize() throws UaException {
        try {
            return this.readSizeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSize(ULong value) throws UaException {
        try {
            this.writeSizeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ULong> readSizeAsync() {
        return ((CompletableFuture)this.getSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ULong)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSizeAsync(ULong size) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)size));
        return this.getSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSizeNode() throws UaException {
        try {
            return this.getSizeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Size", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getWritable() throws UaException {
        PropertyTypeNode node = this.getWritableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setWritable(Boolean value) throws UaException {
        PropertyTypeNode node = this.getWritableNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readWritable() throws UaException {
        try {
            return this.readWritableAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeWritable(Boolean value) throws UaException {
        try {
            this.writeWritableAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readWritableAsync() {
        return ((CompletableFuture)this.getWritableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeWritableAsync(Boolean writable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)writable));
        return this.getWritableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getWritableNode() throws UaException {
        try {
            return this.getWritableNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getWritableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Writable", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getUserWritable() throws UaException {
        PropertyTypeNode node = this.getUserWritableNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setUserWritable(Boolean value) throws UaException {
        PropertyTypeNode node = this.getUserWritableNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readUserWritable() throws UaException {
        try {
            return this.readUserWritableAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUserWritable(Boolean value) throws UaException {
        try {
            this.writeUserWritableAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readUserWritableAsync() {
        return ((CompletableFuture)this.getUserWritableNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUserWritableAsync(Boolean userWritable) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)userWritable));
        return this.getUserWritableNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getUserWritableNode() throws UaException {
        try {
            return this.getUserWritableNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getUserWritableNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UserWritable", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UShort getOpenCount() throws UaException {
        PropertyTypeNode node = this.getOpenCountNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setOpenCount(UShort value) throws UaException {
        PropertyTypeNode node = this.getOpenCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readOpenCount() throws UaException {
        try {
            return this.readOpenCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOpenCount(UShort value) throws UaException {
        try {
            this.writeOpenCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readOpenCountAsync() {
        return ((CompletableFuture)this.getOpenCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOpenCountAsync(UShort openCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)openCount));
        return this.getOpenCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOpenCountNode() throws UaException {
        try {
            return this.getOpenCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOpenCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OpenCount", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getMimeType() throws UaException {
        PropertyTypeNode node = this.getMimeTypeNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setMimeType(String value) throws UaException {
        PropertyTypeNode node = this.getMimeTypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readMimeType() throws UaException {
        try {
            return this.readMimeTypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMimeType(String value) throws UaException {
        try {
            this.writeMimeTypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readMimeTypeAsync() {
        return ((CompletableFuture)this.getMimeTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMimeTypeAsync(String mimeType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)mimeType));
        return this.getMimeTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMimeTypeNode() throws UaException {
        try {
            return this.getMimeTypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMimeTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MimeType", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public UInteger getMaxByteStringLength() throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxByteStringLength(UInteger value) throws UaException {
        PropertyTypeNode node = this.getMaxByteStringLengthNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaxByteStringLength() throws UaException {
        try {
            return this.readMaxByteStringLengthAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxByteStringLength(UInteger value) throws UaException {
        try {
            this.writeMaxByteStringLengthAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxByteStringLengthAsync() {
        return ((CompletableFuture)this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxByteStringLengthAsync(UInteger maxByteStringLength) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxByteStringLength));
        return this.getMaxByteStringLengthNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxByteStringLengthNode() throws UaException {
        try {
            return this.getMaxByteStringLengthNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxByteStringLengthNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxByteStringLength", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public DateTime getLastModifiedTime() throws UaException {
        PropertyTypeNode node = this.getLastModifiedTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastModifiedTime(DateTime value) throws UaException {
        PropertyTypeNode node = this.getLastModifiedTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readLastModifiedTime() throws UaException {
        try {
            return this.readLastModifiedTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastModifiedTime(DateTime value) throws UaException {
        try {
            this.writeLastModifiedTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readLastModifiedTimeAsync() {
        return ((CompletableFuture)this.getLastModifiedTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastModifiedTimeAsync(DateTime lastModifiedTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastModifiedTime));
        return this.getLastModifiedTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLastModifiedTimeNode() throws UaException {
        try {
            return this.getLastModifiedTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLastModifiedTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastModifiedTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

