/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.ExclusiveLimitAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.objects.ExclusiveLimitStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.LimitAlarmTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ExclusiveLimitAlarmTypeNode
extends LimitAlarmTypeNode
implements ExclusiveLimitAlarmType {
    public ExclusiveLimitAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LocalizedText getActiveState() throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setActiveState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readActiveState() throws UaException {
        try {
            return this.readActiveStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActiveState(LocalizedText value) throws UaException {
        try {
            this.writeActiveStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readActiveStateAsync() {
        return ((CompletableFuture)this.getActiveStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActiveStateAsync(LocalizedText activeState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)activeState));
        return this.getActiveStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getActiveStateNode() throws UaException {
        try {
            return this.getActiveStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getActiveStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActiveState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public ExclusiveLimitStateMachineTypeNode getLimitStateNode() throws UaException {
        try {
            return this.getLimitStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ExclusiveLimitStateMachineTypeNode> getLimitStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LimitState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ExclusiveLimitStateMachineTypeNode)node);
    }
}

