/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlarmConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DiscrepancyAlarmType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DiscrepancyAlarmTypeNode
extends AlarmConditionTypeNode
implements DiscrepancyAlarmType {
    public DiscrepancyAlarmTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getTargetValueNode() throws UaException {
        PropertyTypeNode node = this.getTargetValueNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setTargetValueNode(NodeId value) throws UaException {
        PropertyTypeNode node = this.getTargetValueNodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readTargetValueNode() throws UaException {
        try {
            return this.readTargetValueNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTargetValueNode(NodeId value) throws UaException {
        try {
            this.writeTargetValueNodeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readTargetValueNodeAsync() {
        return ((CompletableFuture)this.getTargetValueNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTargetValueNodeAsync(NodeId targetValueNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)targetValueNode));
        return this.getTargetValueNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTargetValueNodeNode() throws UaException {
        try {
            return this.getTargetValueNodeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTargetValueNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TargetValueNode", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getExpectedTime() throws UaException {
        PropertyTypeNode node = this.getExpectedTimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setExpectedTime(Double value) throws UaException {
        PropertyTypeNode node = this.getExpectedTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readExpectedTime() throws UaException {
        try {
            return this.readExpectedTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeExpectedTime(Double value) throws UaException {
        try {
            this.writeExpectedTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readExpectedTimeAsync() {
        return ((CompletableFuture)this.getExpectedTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeExpectedTimeAsync(Double expectedTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)expectedTime));
        return this.getExpectedTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getExpectedTimeNode() throws UaException {
        try {
            return this.getExpectedTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getExpectedTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ExpectedTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getTolerance() throws UaException {
        PropertyTypeNode node = this.getToleranceNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setTolerance(Double value) throws UaException {
        PropertyTypeNode node = this.getToleranceNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readTolerance() throws UaException {
        try {
            return this.readToleranceAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTolerance(Double value) throws UaException {
        try {
            this.writeToleranceAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readToleranceAsync() {
        return ((CompletableFuture)this.getToleranceNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeToleranceAsync(Double tolerance) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)tolerance));
        return this.getToleranceNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getToleranceNode() throws UaException {
        try {
            return this.getToleranceNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getToleranceNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Tolerance", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

