/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetReaderTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.DatagramDataSetReaderTransportType;
import org.eclipse.milo.opcua.sdk.client.model.objects.NetworkAddressTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.ReceiveQosDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class DatagramDataSetReaderTransportTypeNode
extends DataSetReaderTransportTypeNode
implements DatagramDataSetReaderTransportType {
    public DatagramDataSetReaderTransportTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getQosCategory() throws UaException {
        PropertyTypeNode node = this.getQosCategoryNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setQosCategory(String value) throws UaException {
        PropertyTypeNode node = this.getQosCategoryNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readQosCategory() throws UaException {
        try {
            return this.readQosCategoryAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQosCategory(String value) throws UaException {
        try {
            this.writeQosCategoryAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readQosCategoryAsync() {
        return ((CompletableFuture)this.getQosCategoryNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeQosCategoryAsync(String qosCategory) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)qosCategory));
        return this.getQosCategoryNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getQosCategoryNode() throws UaException {
        try {
            return this.getQosCategoryNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getQosCategoryNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "QosCategory", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ReceiveQosDataType[] getDatagramQos() throws UaException {
        PropertyTypeNode node = this.getDatagramQosNode();
        return this.cast(node.getValue().getValue().getValue(), ReceiveQosDataType[].class);
    }

    @Override
    public void setDatagramQos(ReceiveQosDataType[] value) throws UaException {
        PropertyTypeNode node = this.getDatagramQosNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public ReceiveQosDataType[] readDatagramQos() throws UaException {
        try {
            return this.readDatagramQosAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDatagramQos(ReceiveQosDataType[] value) throws UaException {
        try {
            this.writeDatagramQosAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ReceiveQosDataType[]> readDatagramQosAsync() {
        return ((CompletableFuture)this.getDatagramQosNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ReceiveQosDataType[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDatagramQosAsync(ReceiveQosDataType[] datagramQos) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])datagramQos);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDatagramQosNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getDatagramQosNode() throws UaException {
        try {
            return this.getDatagramQosNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getDatagramQosNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DatagramQos", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getTopic() throws UaException {
        PropertyTypeNode node = this.getTopicNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setTopic(String value) throws UaException {
        PropertyTypeNode node = this.getTopicNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readTopic() throws UaException {
        try {
            return this.readTopicAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTopic(String value) throws UaException {
        try {
            this.writeTopicAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readTopicAsync() {
        return ((CompletableFuture)this.getTopicNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeTopicAsync(String topic) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)topic));
        return this.getTopicNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getTopicNode() throws UaException {
        try {
            return this.getTopicNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getTopicNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Topic", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NetworkAddressTypeNode getAddressNode() throws UaException {
        try {
            return this.getAddressNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends NetworkAddressTypeNode> getAddressNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Address", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (NetworkAddressTypeNode)node);
    }
}

