/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ConditionType;
import org.eclipse.milo.opcua.sdk.client.model.variables.ConditionVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ConditionTypeNode
extends BaseEventTypeNode
implements ConditionType {
    public ConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getConditionClassId() throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassId(NodeId value) throws UaException {
        PropertyTypeNode node = this.getConditionClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readConditionClassId() throws UaException {
        try {
            return this.readConditionClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionClassId(NodeId value) throws UaException {
        try {
            this.writeConditionClassIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readConditionClassIdAsync() {
        return ((CompletableFuture)this.getConditionClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassIdAsync(NodeId conditionClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionClassId));
        return this.getConditionClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassIdNode() throws UaException {
        try {
            return this.getConditionClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getConditionClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getConditionClassName() throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionClassName(LocalizedText value) throws UaException {
        PropertyTypeNode node = this.getConditionClassNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readConditionClassName() throws UaException {
        try {
            return this.readConditionClassNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionClassName(LocalizedText value) throws UaException {
        try {
            this.writeConditionClassNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readConditionClassNameAsync() {
        return ((CompletableFuture)this.getConditionClassNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionClassNameAsync(LocalizedText conditionClassName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionClassName));
        return this.getConditionClassNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionClassNameNode() throws UaException {
        try {
            return this.getConditionClassNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getConditionClassNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionClassName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId[] getConditionSubClassId() throws UaException {
        PropertyTypeNode node = this.getConditionSubClassIdNode();
        return (NodeId[])node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionSubClassId(NodeId[] value) throws UaException {
        PropertyTypeNode node = this.getConditionSubClassIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId[] readConditionSubClassId() throws UaException {
        try {
            return this.readConditionSubClassIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionSubClassId(NodeId[] value) throws UaException {
        try {
            this.writeConditionSubClassIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId[]> readConditionSubClassIdAsync() {
        return ((CompletableFuture)this.getConditionSubClassIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionSubClassIdAsync(NodeId[] conditionSubClassId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionSubClassId));
        return this.getConditionSubClassIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionSubClassIdNode() throws UaException {
        try {
            return this.getConditionSubClassIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getConditionSubClassIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionSubClassId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText[] getConditionSubClassName() throws UaException {
        PropertyTypeNode node = this.getConditionSubClassNameNode();
        return (LocalizedText[])node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionSubClassName(LocalizedText[] value) throws UaException {
        PropertyTypeNode node = this.getConditionSubClassNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText[] readConditionSubClassName() throws UaException {
        try {
            return this.readConditionSubClassNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionSubClassName(LocalizedText[] value) throws UaException {
        try {
            this.writeConditionSubClassNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText[]> readConditionSubClassNameAsync() {
        return ((CompletableFuture)this.getConditionSubClassNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionSubClassNameAsync(LocalizedText[] conditionSubClassName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionSubClassName));
        return this.getConditionSubClassNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionSubClassNameNode() throws UaException {
        try {
            return this.getConditionSubClassNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getConditionSubClassNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionSubClassName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getConditionName() throws UaException {
        PropertyTypeNode node = this.getConditionNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionName(String value) throws UaException {
        PropertyTypeNode node = this.getConditionNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readConditionName() throws UaException {
        try {
            return this.readConditionNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionName(String value) throws UaException {
        try {
            this.writeConditionNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readConditionNameAsync() {
        return ((CompletableFuture)this.getConditionNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionNameAsync(String conditionName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionName));
        return this.getConditionNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionNameNode() throws UaException {
        try {
            return this.getConditionNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public NodeId getBranchId() throws UaException {
        PropertyTypeNode node = this.getBranchIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setBranchId(NodeId value) throws UaException {
        PropertyTypeNode node = this.getBranchIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readBranchId() throws UaException {
        try {
            return this.readBranchIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBranchId(NodeId value) throws UaException {
        try {
            this.writeBranchIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readBranchIdAsync() {
        return ((CompletableFuture)this.getBranchIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeBranchIdAsync(NodeId branchId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)branchId));
        return this.getBranchIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getBranchIdNode() throws UaException {
        try {
            return this.getBranchIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getBranchIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BranchId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getRetain() throws UaException {
        PropertyTypeNode node = this.getRetainNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setRetain(Boolean value) throws UaException {
        PropertyTypeNode node = this.getRetainNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readRetain() throws UaException {
        try {
            return this.readRetainAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRetain(Boolean value) throws UaException {
        try {
            this.writeRetainAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readRetainAsync() {
        return ((CompletableFuture)this.getRetainNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRetainAsync(Boolean retain) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)retain));
        return this.getRetainNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRetainNode() throws UaException {
        try {
            return this.getRetainNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRetainNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Retain", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSupportsFilteredRetain() throws UaException {
        PropertyTypeNode node = this.getSupportsFilteredRetainNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSupportsFilteredRetain(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSupportsFilteredRetainNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSupportsFilteredRetain() throws UaException {
        try {
            return this.readSupportsFilteredRetainAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSupportsFilteredRetain(Boolean value) throws UaException {
        try {
            this.writeSupportsFilteredRetainAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSupportsFilteredRetainAsync() {
        return ((CompletableFuture)this.getSupportsFilteredRetainNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSupportsFilteredRetainAsync(Boolean supportsFilteredRetain) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)supportsFilteredRetain));
        return this.getSupportsFilteredRetainNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSupportsFilteredRetainNode() throws UaException {
        try {
            return this.getSupportsFilteredRetainNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSupportsFilteredRetainNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SupportsFilteredRetain", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientUserId() throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientUserId(String value) throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readClientUserId() throws UaException {
        try {
            return this.readClientUserIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientUserId(String value) throws UaException {
        try {
            this.writeClientUserIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientUserIdAsync() {
        return ((CompletableFuture)this.getClientUserIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientUserIdAsync(String clientUserId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientUserId));
        return this.getClientUserIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientUserIdNode() throws UaException {
        try {
            return this.getClientUserIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientUserIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientUserId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledState(LocalizedText value) throws UaException {
        try {
            this.writeEnabledStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledState));
        return this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public StatusCode getQuality() throws UaException {
        ConditionVariableTypeNode node = this.getQualityNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setQuality(StatusCode value) throws UaException {
        ConditionVariableTypeNode node = this.getQualityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public StatusCode readQuality() throws UaException {
        try {
            return this.readQualityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQuality(StatusCode value) throws UaException {
        try {
            this.writeQualityAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readQualityAsync() {
        return ((CompletableFuture)this.getQualityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeQualityAsync(StatusCode quality) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)quality));
        return this.getQualityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getQualityNode() throws UaException {
        try {
            return this.getQualityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getQualityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Quality", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }

    @Override
    public UShort getLastSeverity() throws UaException {
        ConditionVariableTypeNode node = this.getLastSeverityNode();
        return (UShort)node.getValue().getValue().getValue();
    }

    @Override
    public void setLastSeverity(UShort value) throws UaException {
        ConditionVariableTypeNode node = this.getLastSeverityNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UShort readLastSeverity() throws UaException {
        try {
            return this.readLastSeverityAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLastSeverity(UShort value) throws UaException {
        try {
            this.writeLastSeverityAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UShort> readLastSeverityAsync() {
        return ((CompletableFuture)this.getLastSeverityNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UShort)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLastSeverityAsync(UShort lastSeverity) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)lastSeverity));
        return this.getLastSeverityNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getLastSeverityNode() throws UaException {
        try {
            return this.getLastSeverityNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getLastSeverityNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LastSeverity", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }

    @Override
    public LocalizedText getComment() throws UaException {
        ConditionVariableTypeNode node = this.getCommentNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setComment(LocalizedText value) throws UaException {
        ConditionVariableTypeNode node = this.getCommentNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readComment() throws UaException {
        try {
            return this.readCommentAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeComment(LocalizedText value) throws UaException {
        try {
            this.writeCommentAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCommentAsync() {
        return ((CompletableFuture)this.getCommentNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCommentAsync(LocalizedText comment) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)comment));
        return this.getCommentNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public ConditionVariableTypeNode getCommentNode() throws UaException {
        try {
            return this.getCommentNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ConditionVariableTypeNode> getCommentNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Comment", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ConditionVariableTypeNode)node);
    }
}

