/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.BrokerDataSetWriterTransportType;
import org.eclipse.milo.opcua.sdk.client.model.objects.DataSetWriterTransportTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrokerTransportQualityOfService;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class BrokerDataSetWriterTransportTypeNode
extends DataSetWriterTransportTypeNode
implements BrokerDataSetWriterTransportType {
    public BrokerDataSetWriterTransportTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getQueueName() throws UaException {
        PropertyTypeNode node = this.getQueueNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setQueueName(String value) throws UaException {
        PropertyTypeNode node = this.getQueueNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readQueueName() throws UaException {
        try {
            return this.readQueueNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQueueName(String value) throws UaException {
        try {
            this.writeQueueNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readQueueNameAsync() {
        return ((CompletableFuture)this.getQueueNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeQueueNameAsync(String queueName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)queueName));
        return this.getQueueNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getQueueNameNode() throws UaException {
        try {
            return this.getQueueNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getQueueNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "QueueName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getMetaDataQueueName() throws UaException {
        PropertyTypeNode node = this.getMetaDataQueueNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setMetaDataQueueName(String value) throws UaException {
        PropertyTypeNode node = this.getMetaDataQueueNameNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readMetaDataQueueName() throws UaException {
        try {
            return this.readMetaDataQueueNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMetaDataQueueName(String value) throws UaException {
        try {
            this.writeMetaDataQueueNameAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readMetaDataQueueNameAsync() {
        return ((CompletableFuture)this.getMetaDataQueueNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMetaDataQueueNameAsync(String metaDataQueueName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)metaDataQueueName));
        return this.getMetaDataQueueNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMetaDataQueueNameNode() throws UaException {
        try {
            return this.getMetaDataQueueNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMetaDataQueueNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MetaDataQueueName", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getResourceUri() throws UaException {
        PropertyTypeNode node = this.getResourceUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setResourceUri(String value) throws UaException {
        PropertyTypeNode node = this.getResourceUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readResourceUri() throws UaException {
        try {
            return this.readResourceUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeResourceUri(String value) throws UaException {
        try {
            this.writeResourceUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readResourceUriAsync() {
        return ((CompletableFuture)this.getResourceUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeResourceUriAsync(String resourceUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)resourceUri));
        return this.getResourceUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getResourceUriNode() throws UaException {
        try {
            return this.getResourceUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getResourceUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ResourceUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getAuthenticationProfileUri() throws UaException {
        PropertyTypeNode node = this.getAuthenticationProfileUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setAuthenticationProfileUri(String value) throws UaException {
        PropertyTypeNode node = this.getAuthenticationProfileUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readAuthenticationProfileUri() throws UaException {
        try {
            return this.readAuthenticationProfileUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAuthenticationProfileUri(String value) throws UaException {
        try {
            this.writeAuthenticationProfileUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readAuthenticationProfileUriAsync() {
        return ((CompletableFuture)this.getAuthenticationProfileUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAuthenticationProfileUriAsync(String authenticationProfileUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)authenticationProfileUri));
        return this.getAuthenticationProfileUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAuthenticationProfileUriNode() throws UaException {
        try {
            return this.getAuthenticationProfileUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAuthenticationProfileUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AuthenticationProfileUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public BrokerTransportQualityOfService getRequestedDeliveryGuarantee() throws UaException {
        PropertyTypeNode node = this.getRequestedDeliveryGuaranteeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return BrokerTransportQualityOfService.from((int)((Integer)value));
        }
        if (value instanceof BrokerTransportQualityOfService) {
            return (BrokerTransportQualityOfService)value;
        }
        return null;
    }

    @Override
    public void setRequestedDeliveryGuarantee(BrokerTransportQualityOfService value) throws UaException {
        PropertyTypeNode node = this.getRequestedDeliveryGuaranteeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public BrokerTransportQualityOfService readRequestedDeliveryGuarantee() throws UaException {
        try {
            return this.readRequestedDeliveryGuaranteeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRequestedDeliveryGuarantee(BrokerTransportQualityOfService value) throws UaException {
        try {
            this.writeRequestedDeliveryGuaranteeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends BrokerTransportQualityOfService> readRequestedDeliveryGuaranteeAsync() {
        return ((CompletableFuture)this.getRequestedDeliveryGuaranteeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return BrokerTransportQualityOfService.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeRequestedDeliveryGuaranteeAsync(BrokerTransportQualityOfService requestedDeliveryGuarantee) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)requestedDeliveryGuarantee));
        return this.getRequestedDeliveryGuaranteeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRequestedDeliveryGuaranteeNode() throws UaException {
        try {
            return this.getRequestedDeliveryGuaranteeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRequestedDeliveryGuaranteeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RequestedDeliveryGuarantee", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMetaDataUpdateTime() throws UaException {
        PropertyTypeNode node = this.getMetaDataUpdateTimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMetaDataUpdateTime(Double value) throws UaException {
        PropertyTypeNode node = this.getMetaDataUpdateTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMetaDataUpdateTime() throws UaException {
        try {
            return this.readMetaDataUpdateTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMetaDataUpdateTime(Double value) throws UaException {
        try {
            this.writeMetaDataUpdateTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMetaDataUpdateTimeAsync() {
        return ((CompletableFuture)this.getMetaDataUpdateTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMetaDataUpdateTimeAsync(Double metaDataUpdateTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)metaDataUpdateTime));
        return this.getMetaDataUpdateTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMetaDataUpdateTimeNode() throws UaException {
        try {
            return this.getMetaDataUpdateTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMetaDataUpdateTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MetaDataUpdateTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

