/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditChannelEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditOpenSecureChannelEventType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditOpenSecureChannelEventTypeNode
extends AuditChannelEventTypeNode
implements AuditOpenSecureChannelEventType {
    public AuditOpenSecureChannelEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ByteString getClientCertificate() throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificate(ByteString value) throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ByteString readClientCertificate() throws UaException {
        try {
            return this.readClientCertificateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificate(ByteString value) throws UaException {
        try {
            this.writeClientCertificateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readClientCertificateAsync() {
        return ((CompletableFuture)this.getClientCertificateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateAsync(ByteString clientCertificate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificate));
        return this.getClientCertificateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateNode() throws UaException {
        try {
            return this.getClientCertificateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificate", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientCertificateThumbprint() throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificateThumbprint(String value) throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readClientCertificateThumbprint() throws UaException {
        try {
            return this.readClientCertificateThumbprintAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificateThumbprint(String value) throws UaException {
        try {
            this.writeClientCertificateThumbprintAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientCertificateThumbprintAsync() {
        return ((CompletableFuture)this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateThumbprintAsync(String clientCertificateThumbprint) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificateThumbprint));
        return this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateThumbprintNode() throws UaException {
        try {
            return this.getClientCertificateThumbprintNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateThumbprintNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificateThumbprint", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public SecurityTokenRequestType getRequestType() throws UaException {
        PropertyTypeNode node = this.getRequestTypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return SecurityTokenRequestType.from((int)((Integer)value));
        }
        if (value instanceof SecurityTokenRequestType) {
            return (SecurityTokenRequestType)value;
        }
        return null;
    }

    @Override
    public void setRequestType(SecurityTokenRequestType value) throws UaException {
        PropertyTypeNode node = this.getRequestTypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public SecurityTokenRequestType readRequestType() throws UaException {
        try {
            return this.readRequestTypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRequestType(SecurityTokenRequestType value) throws UaException {
        try {
            this.writeRequestTypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends SecurityTokenRequestType> readRequestTypeAsync() {
        return ((CompletableFuture)this.getRequestTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return SecurityTokenRequestType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeRequestTypeAsync(SecurityTokenRequestType requestType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)requestType));
        return this.getRequestTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRequestTypeNode() throws UaException {
        try {
            return this.getRequestTypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRequestTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RequestType", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getSecurityPolicyUri() throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecurityPolicyUri(String value) throws UaException {
        PropertyTypeNode node = this.getSecurityPolicyUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecurityPolicyUri() throws UaException {
        try {
            return this.readSecurityPolicyUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityPolicyUri(String value) throws UaException {
        try {
            this.writeSecurityPolicyUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecurityPolicyUriAsync() {
        return ((CompletableFuture)this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityPolicyUriAsync(String securityPolicyUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityPolicyUri));
        return this.getSecurityPolicyUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityPolicyUriNode() throws UaException {
        try {
            return this.getSecurityPolicyUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityPolicyUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityPolicyUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public MessageSecurityMode getSecurityMode() throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return MessageSecurityMode.from((int)((Integer)value));
        }
        if (value instanceof MessageSecurityMode) {
            return (MessageSecurityMode)value;
        }
        return null;
    }

    @Override
    public void setSecurityMode(MessageSecurityMode value) throws UaException {
        PropertyTypeNode node = this.getSecurityModeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public MessageSecurityMode readSecurityMode() throws UaException {
        try {
            return this.readSecurityModeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecurityMode(MessageSecurityMode value) throws UaException {
        try {
            this.writeSecurityModeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends MessageSecurityMode> readSecurityModeAsync() {
        return ((CompletableFuture)this.getSecurityModeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return MessageSecurityMode.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeSecurityModeAsync(MessageSecurityMode securityMode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)securityMode));
        return this.getSecurityModeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecurityModeNode() throws UaException {
        try {
            return this.getSecurityModeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecurityModeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecurityMode", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getRequestedLifetime() throws UaException {
        PropertyTypeNode node = this.getRequestedLifetimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setRequestedLifetime(Double value) throws UaException {
        PropertyTypeNode node = this.getRequestedLifetimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readRequestedLifetime() throws UaException {
        try {
            return this.readRequestedLifetimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRequestedLifetime(Double value) throws UaException {
        try {
            this.writeRequestedLifetimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readRequestedLifetimeAsync() {
        return ((CompletableFuture)this.getRequestedLifetimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRequestedLifetimeAsync(Double requestedLifetime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)requestedLifetime));
        return this.getRequestedLifetimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRequestedLifetimeNode() throws UaException {
        try {
            return this.getRequestedLifetimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRequestedLifetimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RequestedLifetime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ByteString getCertificateErrorEventId() throws UaException {
        PropertyTypeNode node = this.getCertificateErrorEventIdNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setCertificateErrorEventId(ByteString value) throws UaException {
        PropertyTypeNode node = this.getCertificateErrorEventIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ByteString readCertificateErrorEventId() throws UaException {
        try {
            return this.readCertificateErrorEventIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCertificateErrorEventId(ByteString value) throws UaException {
        try {
            this.writeCertificateErrorEventIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readCertificateErrorEventIdAsync() {
        return ((CompletableFuture)this.getCertificateErrorEventIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCertificateErrorEventIdAsync(ByteString certificateErrorEventId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)certificateErrorEventId));
        return this.getCertificateErrorEventIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCertificateErrorEventIdNode() throws UaException {
        try {
            return this.getCertificateErrorEventIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCertificateErrorEventIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CertificateErrorEventId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

