/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditHistoryAnnotationUpdateEventType;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditHistoryUpdateEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.PerformUpdateType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.Annotation;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditHistoryAnnotationUpdateEventTypeNode
extends AuditHistoryUpdateEventTypeNode
implements AuditHistoryAnnotationUpdateEventType {
    public AuditHistoryAnnotationUpdateEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public PerformUpdateType getPerformInsertReplace() throws UaException {
        PropertyTypeNode node = this.getPerformInsertReplaceNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return PerformUpdateType.from((int)((Integer)value));
        }
        if (value instanceof PerformUpdateType) {
            return (PerformUpdateType)value;
        }
        return null;
    }

    @Override
    public void setPerformInsertReplace(PerformUpdateType value) throws UaException {
        PropertyTypeNode node = this.getPerformInsertReplaceNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public PerformUpdateType readPerformInsertReplace() throws UaException {
        try {
            return this.readPerformInsertReplaceAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePerformInsertReplace(PerformUpdateType value) throws UaException {
        try {
            this.writePerformInsertReplaceAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends PerformUpdateType> readPerformInsertReplaceAsync() {
        return ((CompletableFuture)this.getPerformInsertReplaceNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return PerformUpdateType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writePerformInsertReplaceAsync(PerformUpdateType performInsertReplace) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)performInsertReplace));
        return this.getPerformInsertReplaceNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getPerformInsertReplaceNode() throws UaException {
        try {
            return this.getPerformInsertReplaceNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getPerformInsertReplaceNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PerformInsertReplace", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Annotation[] getNewValues() throws UaException {
        PropertyTypeNode node = this.getNewValuesNode();
        return this.cast(node.getValue().getValue().getValue(), Annotation[].class);
    }

    @Override
    public void setNewValues(Annotation[] value) throws UaException {
        PropertyTypeNode node = this.getNewValuesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Annotation[] readNewValues() throws UaException {
        try {
            return this.readNewValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeNewValues(Annotation[] value) throws UaException {
        try {
            this.writeNewValuesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Annotation[]> readNewValuesAsync() {
        return ((CompletableFuture)this.getNewValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Annotation[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeNewValuesAsync(Annotation[] newValues) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])newValues);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getNewValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getNewValuesNode() throws UaException {
        try {
            return this.getNewValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getNewValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "NewValues", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Annotation[] getOldValues() throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        return this.cast(node.getValue().getValue().getValue(), Annotation[].class);
    }

    @Override
    public void setOldValues(Annotation[] value) throws UaException {
        PropertyTypeNode node = this.getOldValuesNode();
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public Annotation[] readOldValues() throws UaException {
        try {
            return this.readOldValuesAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOldValues(Annotation[] value) throws UaException {
        try {
            this.writeOldValuesAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Annotation[]> readOldValuesAsync() {
        return ((CompletableFuture)this.getOldValuesNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Annotation[].class));
    }

    @Override
    public CompletableFuture<StatusCode> writeOldValuesAsync(Annotation[] oldValues) {
        ExtensionObject[] encoded = ExtensionObject.encodeArray((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType[])oldValues);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getOldValuesNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOldValuesNode() throws UaException {
        try {
            return this.getOldValuesNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOldValuesNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OldValues", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

