/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditEventType;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditEventTypeNode
extends BaseEventTypeNode
implements AuditEventType {
    public AuditEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public DateTime getActionTimeStamp() throws UaException {
        PropertyTypeNode node = this.getActionTimeStampNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setActionTimeStamp(DateTime value) throws UaException {
        PropertyTypeNode node = this.getActionTimeStampNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readActionTimeStamp() throws UaException {
        try {
            return this.readActionTimeStampAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActionTimeStamp(DateTime value) throws UaException {
        try {
            this.writeActionTimeStampAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readActionTimeStampAsync() {
        return ((CompletableFuture)this.getActionTimeStampNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActionTimeStampAsync(DateTime actionTimeStamp) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)actionTimeStamp));
        return this.getActionTimeStampNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getActionTimeStampNode() throws UaException {
        try {
            return this.getActionTimeStampNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getActionTimeStampNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActionTimeStamp", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getStatus() throws UaException {
        PropertyTypeNode node = this.getStatusNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setStatus(Boolean value) throws UaException {
        PropertyTypeNode node = this.getStatusNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readStatus() throws UaException {
        try {
            return this.readStatusAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStatus(Boolean value) throws UaException {
        try {
            this.writeStatusAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readStatusAsync() {
        return ((CompletableFuture)this.getStatusNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStatusAsync(Boolean status) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)status));
        return this.getStatusNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStatusNode() throws UaException {
        try {
            return this.getStatusNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStatusNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Status", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getServerId() throws UaException {
        PropertyTypeNode node = this.getServerIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setServerId(String value) throws UaException {
        PropertyTypeNode node = this.getServerIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readServerId() throws UaException {
        try {
            return this.readServerIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerId(String value) throws UaException {
        try {
            this.writeServerIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readServerIdAsync() {
        return ((CompletableFuture)this.getServerIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerIdAsync(String serverId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverId));
        return this.getServerIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getServerIdNode() throws UaException {
        try {
            return this.getServerIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getServerIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientAuditEntryId() throws UaException {
        PropertyTypeNode node = this.getClientAuditEntryIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientAuditEntryId(String value) throws UaException {
        PropertyTypeNode node = this.getClientAuditEntryIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readClientAuditEntryId() throws UaException {
        try {
            return this.readClientAuditEntryIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientAuditEntryId(String value) throws UaException {
        try {
            this.writeClientAuditEntryIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientAuditEntryIdAsync() {
        return ((CompletableFuture)this.getClientAuditEntryIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientAuditEntryIdAsync(String clientAuditEntryId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientAuditEntryId));
        return this.getClientAuditEntryIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientAuditEntryIdNode() throws UaException {
        try {
            return this.getClientAuditEntryIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientAuditEntryIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientAuditEntryId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientUserId() throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientUserId(String value) throws UaException {
        PropertyTypeNode node = this.getClientUserIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readClientUserId() throws UaException {
        try {
            return this.readClientUserIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientUserId(String value) throws UaException {
        try {
            this.writeClientUserIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientUserIdAsync() {
        return ((CompletableFuture)this.getClientUserIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientUserIdAsync(String clientUserId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientUserId));
        return this.getClientUserIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientUserIdNode() throws UaException {
        try {
            return this.getClientUserIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientUserIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientUserId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

