/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditCreateSessionEventType;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditSessionEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditCreateSessionEventTypeNode
extends AuditSessionEventTypeNode
implements AuditCreateSessionEventType {
    public AuditCreateSessionEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getSecureChannelId() throws UaException {
        PropertyTypeNode node = this.getSecureChannelIdNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSecureChannelId(String value) throws UaException {
        PropertyTypeNode node = this.getSecureChannelIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readSecureChannelId() throws UaException {
        try {
            return this.readSecureChannelIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSecureChannelId(String value) throws UaException {
        try {
            this.writeSecureChannelIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSecureChannelIdAsync() {
        return ((CompletableFuture)this.getSecureChannelIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSecureChannelIdAsync(String secureChannelId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)secureChannelId));
        return this.getSecureChannelIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSecureChannelIdNode() throws UaException {
        try {
            return this.getSecureChannelIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSecureChannelIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SecureChannelId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ByteString getClientCertificate() throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificate(ByteString value) throws UaException {
        PropertyTypeNode node = this.getClientCertificateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ByteString readClientCertificate() throws UaException {
        try {
            return this.readClientCertificateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificate(ByteString value) throws UaException {
        try {
            this.writeClientCertificateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readClientCertificateAsync() {
        return ((CompletableFuture)this.getClientCertificateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateAsync(ByteString clientCertificate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificate));
        return this.getClientCertificateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateNode() throws UaException {
        try {
            return this.getClientCertificateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificate", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getClientCertificateThumbprint() throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientCertificateThumbprint(String value) throws UaException {
        PropertyTypeNode node = this.getClientCertificateThumbprintNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readClientCertificateThumbprint() throws UaException {
        try {
            return this.readClientCertificateThumbprintAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientCertificateThumbprint(String value) throws UaException {
        try {
            this.writeClientCertificateThumbprintAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readClientCertificateThumbprintAsync() {
        return ((CompletableFuture)this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientCertificateThumbprintAsync(String clientCertificateThumbprint) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientCertificateThumbprint));
        return this.getClientCertificateThumbprintNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getClientCertificateThumbprintNode() throws UaException {
        try {
            return this.getClientCertificateThumbprintNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getClientCertificateThumbprintNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientCertificateThumbprint", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getRevisedSessionTimeout() throws UaException {
        PropertyTypeNode node = this.getRevisedSessionTimeoutNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setRevisedSessionTimeout(Double value) throws UaException {
        PropertyTypeNode node = this.getRevisedSessionTimeoutNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readRevisedSessionTimeout() throws UaException {
        try {
            return this.readRevisedSessionTimeoutAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRevisedSessionTimeout(Double value) throws UaException {
        try {
            this.writeRevisedSessionTimeoutAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readRevisedSessionTimeoutAsync() {
        return ((CompletableFuture)this.getRevisedSessionTimeoutNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeRevisedSessionTimeoutAsync(Double revisedSessionTimeout) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)revisedSessionTimeout));
        return this.getRevisedSessionTimeoutNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getRevisedSessionTimeoutNode() throws UaException {
        try {
            return this.getRevisedSessionTimeoutNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getRevisedSessionTimeoutNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RevisedSessionTimeout", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

