/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditClientEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.AuditClientUpdateMethodResultEventType;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AuditClientUpdateMethodResultEventTypeNode
extends AuditClientEventTypeNode
implements AuditClientUpdateMethodResultEventType {
    public AuditClientUpdateMethodResultEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public ExpandedNodeId getObjectId() throws UaException {
        PropertyTypeNode node = this.getObjectIdNode();
        return (ExpandedNodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setObjectId(ExpandedNodeId value) throws UaException {
        PropertyTypeNode node = this.getObjectIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ExpandedNodeId readObjectId() throws UaException {
        try {
            return this.readObjectIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeObjectId(ExpandedNodeId value) throws UaException {
        try {
            this.writeObjectIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ExpandedNodeId> readObjectIdAsync() {
        return ((CompletableFuture)this.getObjectIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ExpandedNodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeObjectIdAsync(ExpandedNodeId objectId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)objectId));
        return this.getObjectIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getObjectIdNode() throws UaException {
        try {
            return this.getObjectIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getObjectIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ObjectId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ExpandedNodeId getMethodId() throws UaException {
        PropertyTypeNode node = this.getMethodIdNode();
        return (ExpandedNodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setMethodId(ExpandedNodeId value) throws UaException {
        PropertyTypeNode node = this.getMethodIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ExpandedNodeId readMethodId() throws UaException {
        try {
            return this.readMethodIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMethodId(ExpandedNodeId value) throws UaException {
        try {
            this.writeMethodIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ExpandedNodeId> readMethodIdAsync() {
        return ((CompletableFuture)this.getMethodIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ExpandedNodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMethodIdAsync(ExpandedNodeId methodId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)methodId));
        return this.getMethodIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMethodIdNode() throws UaException {
        try {
            return this.getMethodIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMethodIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MethodId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public StatusCode getStatusCodeId() throws UaException {
        PropertyTypeNode node = this.getStatusCodeIdNode();
        return (StatusCode)node.getValue().getValue().getValue();
    }

    @Override
    public void setStatusCodeId(StatusCode value) throws UaException {
        PropertyTypeNode node = this.getStatusCodeIdNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public StatusCode readStatusCodeId() throws UaException {
        try {
            return this.readStatusCodeIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStatusCodeId(StatusCode value) throws UaException {
        try {
            this.writeStatusCodeIdAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends StatusCode> readStatusCodeIdAsync() {
        return ((CompletableFuture)this.getStatusCodeIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (StatusCode)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStatusCodeIdAsync(StatusCode statusCodeId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)statusCodeId));
        return this.getStatusCodeIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getStatusCodeIdNode() throws UaException {
        try {
            return this.getStatusCodeIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getStatusCodeIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StatusCodeId", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Object[] getInputArguments() throws UaException {
        PropertyTypeNode node = this.getInputArgumentsNode();
        return (Object[])node.getValue().getValue().getValue();
    }

    @Override
    public void setInputArguments(Object[] value) throws UaException {
        PropertyTypeNode node = this.getInputArgumentsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Object[] readInputArguments() throws UaException {
        try {
            return this.readInputArgumentsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInputArguments(Object[] value) throws UaException {
        try {
            this.writeInputArgumentsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Object[]> readInputArgumentsAsync() {
        return ((CompletableFuture)this.getInputArgumentsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Object[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInputArgumentsAsync(Object[] inputArguments) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)inputArguments));
        return this.getInputArgumentsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInputArgumentsNode() throws UaException {
        try {
            return this.getInputArgumentsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInputArgumentsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InputArguments", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Object[] getOutputArguments() throws UaException {
        PropertyTypeNode node = this.getOutputArgumentsNode();
        return (Object[])node.getValue().getValue().getValue();
    }

    @Override
    public void setOutputArguments(Object[] value) throws UaException {
        PropertyTypeNode node = this.getOutputArgumentsNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Object[] readOutputArguments() throws UaException {
        try {
            return this.readOutputArgumentsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOutputArguments(Object[] value) throws UaException {
        try {
            this.writeOutputArgumentsAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Object[]> readOutputArgumentsAsync() {
        return ((CompletableFuture)this.getOutputArgumentsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Object[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOutputArgumentsAsync(Object[] outputArguments) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)outputArguments));
        return this.getOutputArgumentsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOutputArgumentsNode() throws UaException {
        try {
            return this.getOutputArgumentsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOutputArgumentsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OutputArguments", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

