/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.ApplicationConfigurationType;
import org.eclipse.milo.opcua.sdk.client.model.objects.ServerConfigurationTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class ApplicationConfigurationTypeNode
extends ServerConfigurationTypeNode
implements ApplicationConfigurationType {
    public ApplicationConfigurationTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public String getApplicationUri() throws UaException {
        PropertyTypeNode node = this.getApplicationUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setApplicationUri(String value) throws UaException {
        PropertyTypeNode node = this.getApplicationUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readApplicationUri() throws UaException {
        try {
            return this.readApplicationUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeApplicationUri(String value) throws UaException {
        try {
            this.writeApplicationUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readApplicationUriAsync() {
        return ((CompletableFuture)this.getApplicationUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationUriAsync(String applicationUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationUri));
        return this.getApplicationUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationUriNode() throws UaException {
        try {
            return this.getApplicationUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getApplicationUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getProductUri() throws UaException {
        PropertyTypeNode node = this.getProductUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setProductUri(String value) throws UaException {
        PropertyTypeNode node = this.getProductUriNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readProductUri() throws UaException {
        try {
            return this.readProductUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeProductUri(String value) throws UaException {
        try {
            this.writeProductUriAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readProductUriAsync() {
        return ((CompletableFuture)this.getProductUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeProductUriAsync(String productUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)productUri));
        return this.getProductUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getProductUriNode() throws UaException {
        try {
            return this.getProductUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getProductUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ProductUri", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public ApplicationType getApplicationType() throws UaException {
        PropertyTypeNode node = this.getApplicationTypeNode();
        Object value = node.getValue().getValue().getValue();
        if (value instanceof Integer) {
            return ApplicationType.from((int)((Integer)value));
        }
        if (value instanceof ApplicationType) {
            return (ApplicationType)value;
        }
        return null;
    }

    @Override
    public void setApplicationType(ApplicationType value) throws UaException {
        PropertyTypeNode node = this.getApplicationTypeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ApplicationType readApplicationType() throws UaException {
        try {
            return this.readApplicationTypeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeApplicationType(ApplicationType value) throws UaException {
        try {
            this.writeApplicationTypeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ApplicationType> readApplicationTypeAsync() {
        return ((CompletableFuture)this.getApplicationTypeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> {
            Object value = v.getValue().getValue();
            if (value instanceof Integer) {
                return ApplicationType.from((int)((Integer)value));
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<StatusCode> writeApplicationTypeAsync(ApplicationType applicationType) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)applicationType));
        return this.getApplicationTypeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getApplicationTypeNode() throws UaException {
        try {
            return this.getApplicationTypeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends PropertyTypeNode> getApplicationTypeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ApplicationType", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getEnabled() throws UaException {
        PropertyTypeNode node = this.getEnabledNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabled(Boolean value) throws UaException {
        PropertyTypeNode node = this.getEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readEnabled() throws UaException {
        try {
            return this.readEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabled(Boolean value) throws UaException {
        try {
            this.writeEnabledAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readEnabledAsync() {
        return ((CompletableFuture)this.getEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledAsync(Boolean enabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabled));
        return this.getEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEnabledNode() throws UaException {
        try {
            return this.getEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Enabled", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

