/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlternativeUnitType;
import org.eclipse.milo.opcua.sdk.client.model.objects.UnitTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.encoding.EncodingContext;
import org.eclipse.milo.opcua.stack.core.types.UaStructuredType;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.LinearConversionDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AlternativeUnitTypeNode
extends UnitTypeNode
implements AlternativeUnitType {
    public AlternativeUnitTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public LinearConversionDataType getLinearConversion() throws UaException {
        PropertyTypeNode node = this.getLinearConversionNode();
        return this.cast(node.getValue().getValue().getValue(), LinearConversionDataType.class);
    }

    @Override
    public void setLinearConversion(LinearConversionDataType value) throws UaException {
        PropertyTypeNode node = this.getLinearConversionNode();
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)value);
        node.setValue(new Variant((Object)encoded));
    }

    @Override
    public LinearConversionDataType readLinearConversion() throws UaException {
        try {
            return this.readLinearConversionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLinearConversion(LinearConversionDataType value) throws UaException {
        try {
            this.writeLinearConversionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LinearConversionDataType> readLinearConversionAsync() {
        return ((CompletableFuture)this.getLinearConversionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), LinearConversionDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeLinearConversionAsync(LinearConversionDataType linearConversion) {
        ExtensionObject encoded = ExtensionObject.encode((EncodingContext)this.client.getStaticEncodingContext(), (UaStructuredType)linearConversion);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getLinearConversionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getLinearConversionNode() throws UaException {
        try {
            return this.getLinearConversionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getLinearConversionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LinearConversion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getMathMlConversion() throws UaException {
        PropertyTypeNode node = this.getMathMlConversionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setMathMlConversion(String value) throws UaException {
        PropertyTypeNode node = this.getMathMlConversionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readMathMlConversion() throws UaException {
        try {
            return this.readMathMlConversionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMathMlConversion(String value) throws UaException {
        try {
            this.writeMathMlConversionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readMathMlConversionAsync() {
        return ((CompletableFuture)this.getMathMlConversionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMathMlConversionAsync(String mathMlConversion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)mathMlConversion));
        return this.getMathMlConversionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMathMlConversionNode() throws UaException {
        try {
            return this.getMathMlConversionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMathMlConversionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MathMLConversion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public String getMathMlInverseConversion() throws UaException {
        PropertyTypeNode node = this.getMathMlInverseConversionNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setMathMlInverseConversion(String value) throws UaException {
        PropertyTypeNode node = this.getMathMlInverseConversionNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public String readMathMlInverseConversion() throws UaException {
        try {
            return this.readMathMlInverseConversionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMathMlInverseConversion(String value) throws UaException {
        try {
            this.writeMathMlInverseConversionAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readMathMlInverseConversionAsync() {
        return ((CompletableFuture)this.getMathMlInverseConversionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMathMlInverseConversionAsync(String mathMlInverseConversion) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)mathMlInverseConversion));
        return this.getMathMlInverseConversionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMathMlInverseConversionNode() throws UaException {
        try {
            return this.getMathMlInverseConversionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMathMlInverseConversionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MathMLInverseConversion", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

