/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlarmMetricsType;
import org.eclipse.milo.opcua.sdk.client.model.objects.BaseObjectTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.AlarmRateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AlarmMetricsTypeNode
extends BaseObjectTypeNode
implements AlarmMetricsType {
    public AlarmMetricsTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public UInteger getAlarmCount() throws UaException {
        BaseDataVariableTypeNode node = this.getAlarmCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setAlarmCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getAlarmCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readAlarmCount() throws UaException {
        try {
            return this.readAlarmCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAlarmCount(UInteger value) throws UaException {
        try {
            this.writeAlarmCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readAlarmCountAsync() {
        return ((CompletableFuture)this.getAlarmCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAlarmCountAsync(UInteger alarmCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)alarmCount));
        return this.getAlarmCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAlarmCountNode() throws UaException {
        try {
            return this.getAlarmCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAlarmCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AlarmCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getStartTime() throws UaException {
        BaseDataVariableTypeNode node = this.getStartTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setStartTime(DateTime value) throws UaException {
        BaseDataVariableTypeNode node = this.getStartTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public DateTime readStartTime() throws UaException {
        try {
            return this.readStartTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeStartTime(DateTime value) throws UaException {
        try {
            this.writeStartTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readStartTimeAsync() {
        return ((CompletableFuture)this.getStartTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeStartTimeAsync(DateTime startTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)startTime));
        return this.getStartTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getStartTimeNode() throws UaException {
        try {
            return this.getStartTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getStartTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "StartTime", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getMaximumActiveState() throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumActiveStateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaximumActiveState(Double value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumActiveStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaximumActiveState() throws UaException {
        try {
            return this.readMaximumActiveStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaximumActiveState(Double value) throws UaException {
        try {
            this.writeMaximumActiveStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaximumActiveStateAsync() {
        return ((CompletableFuture)this.getMaximumActiveStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaximumActiveStateAsync(Double maximumActiveState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maximumActiveState));
        return this.getMaximumActiveStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumActiveStateNode() throws UaException {
        try {
            return this.getMaximumActiveStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaximumActiveStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaximumActiveState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getMaximumUnAck() throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumUnAckNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaximumUnAck(Double value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumUnAckNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaximumUnAck() throws UaException {
        try {
            return this.readMaximumUnAckAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaximumUnAck(Double value) throws UaException {
        try {
            this.writeMaximumUnAckAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaximumUnAckAsync() {
        return ((CompletableFuture)this.getMaximumUnAckNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaximumUnAckAsync(Double maximumUnAck) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maximumUnAck));
        return this.getMaximumUnAckNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumUnAckNode() throws UaException {
        try {
            return this.getMaximumUnAckNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaximumUnAckNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaximumUnAck", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getCurrentAlarmRate() throws UaException {
        AlarmRateVariableTypeNode node = this.getCurrentAlarmRateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentAlarmRate(Double value) throws UaException {
        AlarmRateVariableTypeNode node = this.getCurrentAlarmRateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readCurrentAlarmRate() throws UaException {
        try {
            return this.readCurrentAlarmRateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentAlarmRate(Double value) throws UaException {
        try {
            this.writeCurrentAlarmRateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readCurrentAlarmRateAsync() {
        return ((CompletableFuture)this.getCurrentAlarmRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentAlarmRateAsync(Double currentAlarmRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentAlarmRate));
        return this.getCurrentAlarmRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AlarmRateVariableTypeNode getCurrentAlarmRateNode() throws UaException {
        try {
            return this.getCurrentAlarmRateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AlarmRateVariableTypeNode> getCurrentAlarmRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentAlarmRate", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AlarmRateVariableTypeNode)node);
    }

    @Override
    public Double getMaximumAlarmRate() throws UaException {
        AlarmRateVariableTypeNode node = this.getMaximumAlarmRateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaximumAlarmRate(Double value) throws UaException {
        AlarmRateVariableTypeNode node = this.getMaximumAlarmRateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaximumAlarmRate() throws UaException {
        try {
            return this.readMaximumAlarmRateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaximumAlarmRate(Double value) throws UaException {
        try {
            this.writeMaximumAlarmRateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaximumAlarmRateAsync() {
        return ((CompletableFuture)this.getMaximumAlarmRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaximumAlarmRateAsync(Double maximumAlarmRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maximumAlarmRate));
        return this.getMaximumAlarmRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AlarmRateVariableTypeNode getMaximumAlarmRateNode() throws UaException {
        try {
            return this.getMaximumAlarmRateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AlarmRateVariableTypeNode> getMaximumAlarmRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaximumAlarmRate", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AlarmRateVariableTypeNode)node);
    }

    @Override
    public UInteger getMaximumReAlarmCount() throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumReAlarmCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaximumReAlarmCount(UInteger value) throws UaException {
        BaseDataVariableTypeNode node = this.getMaximumReAlarmCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public UInteger readMaximumReAlarmCount() throws UaException {
        try {
            return this.readMaximumReAlarmCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaximumReAlarmCount(UInteger value) throws UaException {
        try {
            this.writeMaximumReAlarmCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaximumReAlarmCountAsync() {
        return ((CompletableFuture)this.getMaximumReAlarmCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaximumReAlarmCountAsync(UInteger maximumReAlarmCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maximumReAlarmCount));
        return this.getMaximumReAlarmCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaximumReAlarmCountNode() throws UaException {
        try {
            return this.getMaximumReAlarmCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaximumReAlarmCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaximumReAlarmCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getAverageAlarmRate() throws UaException {
        AlarmRateVariableTypeNode node = this.getAverageAlarmRateNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setAverageAlarmRate(Double value) throws UaException {
        AlarmRateVariableTypeNode node = this.getAverageAlarmRateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readAverageAlarmRate() throws UaException {
        try {
            return this.readAverageAlarmRateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAverageAlarmRate(Double value) throws UaException {
        try {
            this.writeAverageAlarmRateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readAverageAlarmRateAsync() {
        return ((CompletableFuture)this.getAverageAlarmRateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAverageAlarmRateAsync(Double averageAlarmRate) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)averageAlarmRate));
        return this.getAverageAlarmRateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AlarmRateVariableTypeNode getAverageAlarmRateNode() throws UaException {
        try {
            return this.getAverageAlarmRateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AlarmRateVariableTypeNode> getAverageAlarmRateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AverageAlarmRate", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AlarmRateVariableTypeNode)node);
    }
}

