/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.objects.AcknowledgeableConditionTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlarmConditionType;
import org.eclipse.milo.opcua.sdk.client.model.objects.AlarmGroupTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.objects.ShelvedStateMachineTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.AudioVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.variables.TwoStateVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class AlarmConditionTypeNode
extends AcknowledgeableConditionTypeNode
implements AlarmConditionType {
    public AlarmConditionTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, rolePermissions, userRolePermissions, accessRestrictions, eventNotifier);
    }

    @Override
    public NodeId getInputNode() throws UaException {
        PropertyTypeNode node = this.getInputNodeNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setInputNode(NodeId value) throws UaException {
        PropertyTypeNode node = this.getInputNodeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public NodeId readInputNode() throws UaException {
        try {
            return this.readInputNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInputNode(NodeId value) throws UaException {
        try {
            this.writeInputNodeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readInputNodeAsync() {
        return ((CompletableFuture)this.getInputNodeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeInputNodeAsync(NodeId inputNode) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)inputNode));
        return this.getInputNodeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInputNodeNode() throws UaException {
        try {
            return this.getInputNodeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInputNodeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InputNode", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getSuppressedOrShelved() throws UaException {
        PropertyTypeNode node = this.getSuppressedOrShelvedNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setSuppressedOrShelved(Boolean value) throws UaException {
        PropertyTypeNode node = this.getSuppressedOrShelvedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readSuppressedOrShelved() throws UaException {
        try {
            return this.readSuppressedOrShelvedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSuppressedOrShelved(Boolean value) throws UaException {
        try {
            this.writeSuppressedOrShelvedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readSuppressedOrShelvedAsync() {
        return ((CompletableFuture)this.getSuppressedOrShelvedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSuppressedOrShelvedAsync(Boolean suppressedOrShelved) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)suppressedOrShelved));
        return this.getSuppressedOrShelvedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getSuppressedOrShelvedNode() throws UaException {
        try {
            return this.getSuppressedOrShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getSuppressedOrShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuppressedOrShelved", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getMaxTimeShelved() throws UaException {
        PropertyTypeNode node = this.getMaxTimeShelvedNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxTimeShelved(Double value) throws UaException {
        PropertyTypeNode node = this.getMaxTimeShelvedNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readMaxTimeShelved() throws UaException {
        try {
            return this.readMaxTimeShelvedAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxTimeShelved(Double value) throws UaException {
        try {
            this.writeMaxTimeShelvedAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readMaxTimeShelvedAsync() {
        return ((CompletableFuture)this.getMaxTimeShelvedNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxTimeShelvedAsync(Double maxTimeShelved) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxTimeShelved));
        return this.getMaxTimeShelvedNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getMaxTimeShelvedNode() throws UaException {
        try {
            return this.getMaxTimeShelvedNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getMaxTimeShelvedNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxTimeShelved", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Boolean getAudibleEnabled() throws UaException {
        PropertyTypeNode node = this.getAudibleEnabledNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setAudibleEnabled(Boolean value) throws UaException {
        PropertyTypeNode node = this.getAudibleEnabledNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readAudibleEnabled() throws UaException {
        try {
            return this.readAudibleEnabledAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAudibleEnabled(Boolean value) throws UaException {
        try {
            this.writeAudibleEnabledAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readAudibleEnabledAsync() {
        return ((CompletableFuture)this.getAudibleEnabledNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAudibleEnabledAsync(Boolean audibleEnabled) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)audibleEnabled));
        return this.getAudibleEnabledNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getAudibleEnabledNode() throws UaException {
        try {
            return this.getAudibleEnabledNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getAudibleEnabledNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AudibleEnabled", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getOnDelay() throws UaException {
        PropertyTypeNode node = this.getOnDelayNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setOnDelay(Double value) throws UaException {
        PropertyTypeNode node = this.getOnDelayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readOnDelay() throws UaException {
        try {
            return this.readOnDelayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOnDelay(Double value) throws UaException {
        try {
            this.writeOnDelayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readOnDelayAsync() {
        return ((CompletableFuture)this.getOnDelayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOnDelayAsync(Double onDelay) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)onDelay));
        return this.getOnDelayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOnDelayNode() throws UaException {
        try {
            return this.getOnDelayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOnDelayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OnDelay", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getOffDelay() throws UaException {
        PropertyTypeNode node = this.getOffDelayNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setOffDelay(Double value) throws UaException {
        PropertyTypeNode node = this.getOffDelayNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readOffDelay() throws UaException {
        try {
            return this.readOffDelayAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOffDelay(Double value) throws UaException {
        try {
            this.writeOffDelayAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readOffDelayAsync() {
        return ((CompletableFuture)this.getOffDelayNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOffDelayAsync(Double offDelay) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)offDelay));
        return this.getOffDelayNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getOffDelayNode() throws UaException {
        try {
            return this.getOffDelayNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getOffDelayNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OffDelay", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Double getReAlarmTime() throws UaException {
        PropertyTypeNode node = this.getReAlarmTimeNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setReAlarmTime(Double value) throws UaException {
        PropertyTypeNode node = this.getReAlarmTimeNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Double readReAlarmTime() throws UaException {
        try {
            return this.readReAlarmTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReAlarmTime(Double value) throws UaException {
        try {
            this.writeReAlarmTimeAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readReAlarmTimeAsync() {
        return ((CompletableFuture)this.getReAlarmTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReAlarmTimeAsync(Double reAlarmTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)reAlarmTime));
        return this.getReAlarmTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getReAlarmTimeNode() throws UaException {
        try {
            return this.getReAlarmTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getReAlarmTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReAlarmTime", ExpandedNodeId.parse((String)"ns=0;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getEnabledState() throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setEnabledState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getEnabledStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readEnabledState() throws UaException {
        try {
            return this.readEnabledStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEnabledState(LocalizedText value) throws UaException {
        try {
            this.writeEnabledStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readEnabledStateAsync() {
        return ((CompletableFuture)this.getEnabledStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEnabledStateAsync(LocalizedText enabledState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)enabledState));
        return this.getEnabledStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getEnabledStateNode() throws UaException {
        try {
            return this.getEnabledStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    @Override
    public CompletableFuture<? extends TwoStateVariableTypeNode> getEnabledStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EnabledState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getActiveState() throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setActiveState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getActiveStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readActiveState() throws UaException {
        try {
            return this.readActiveStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActiveState(LocalizedText value) throws UaException {
        try {
            this.writeActiveStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readActiveStateAsync() {
        return ((CompletableFuture)this.getActiveStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActiveStateAsync(LocalizedText activeState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)activeState));
        return this.getActiveStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getActiveStateNode() throws UaException {
        try {
            return this.getActiveStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getActiveStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActiveState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getSuppressedState() throws UaException {
        TwoStateVariableTypeNode node = this.getSuppressedStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setSuppressedState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getSuppressedStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readSuppressedState() throws UaException {
        try {
            return this.readSuppressedStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSuppressedState(LocalizedText value) throws UaException {
        try {
            this.writeSuppressedStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readSuppressedStateAsync() {
        return ((CompletableFuture)this.getSuppressedStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSuppressedStateAsync(LocalizedText suppressedState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)suppressedState));
        return this.getSuppressedStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getSuppressedStateNode() throws UaException {
        try {
            return this.getSuppressedStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getSuppressedStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SuppressedState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public LocalizedText getOutOfServiceState() throws UaException {
        TwoStateVariableTypeNode node = this.getOutOfServiceStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setOutOfServiceState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getOutOfServiceStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readOutOfServiceState() throws UaException {
        try {
            return this.readOutOfServiceStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeOutOfServiceState(LocalizedText value) throws UaException {
        try {
            this.writeOutOfServiceStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readOutOfServiceStateAsync() {
        return ((CompletableFuture)this.getOutOfServiceStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeOutOfServiceStateAsync(LocalizedText outOfServiceState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)outOfServiceState));
        return this.getOutOfServiceStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getOutOfServiceStateNode() throws UaException {
        try {
            return this.getOutOfServiceStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getOutOfServiceStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "OutOfServiceState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public ShelvedStateMachineTypeNode getShelvingStateNode() throws UaException {
        try {
            return this.getShelvingStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends ShelvedStateMachineTypeNode> getShelvingStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ShelvingState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (ShelvedStateMachineTypeNode)node);
    }

    @Override
    public ByteString getAudibleSound() throws UaException {
        AudioVariableTypeNode node = this.getAudibleSoundNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setAudibleSound(ByteString value) throws UaException {
        AudioVariableTypeNode node = this.getAudibleSoundNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ByteString readAudibleSound() throws UaException {
        try {
            return this.readAudibleSoundAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAudibleSound(ByteString value) throws UaException {
        try {
            this.writeAudibleSoundAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readAudibleSoundAsync() {
        return ((CompletableFuture)this.getAudibleSoundNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeAudibleSoundAsync(ByteString audibleSound) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)audibleSound));
        return this.getAudibleSoundNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public AudioVariableTypeNode getAudibleSoundNode() throws UaException {
        try {
            return this.getAudibleSoundNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AudioVariableTypeNode> getAudibleSoundNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AudibleSound", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AudioVariableTypeNode)node);
    }

    @Override
    public LocalizedText getSilenceState() throws UaException {
        TwoStateVariableTypeNode node = this.getSilenceStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setSilenceState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getSilenceStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readSilenceState() throws UaException {
        try {
            return this.readSilenceStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSilenceState(LocalizedText value) throws UaException {
        try {
            this.writeSilenceStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readSilenceStateAsync() {
        return ((CompletableFuture)this.getSilenceStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSilenceStateAsync(LocalizedText silenceState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)silenceState));
        return this.getSilenceStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getSilenceStateNode() throws UaException {
        try {
            return this.getSilenceStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getSilenceStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SilenceState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public Boolean getFirstInGroupFlag() throws UaException {
        BaseDataVariableTypeNode node = this.getFirstInGroupFlagNode();
        return (Boolean)node.getValue().getValue().getValue();
    }

    @Override
    public void setFirstInGroupFlag(Boolean value) throws UaException {
        BaseDataVariableTypeNode node = this.getFirstInGroupFlagNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Boolean readFirstInGroupFlag() throws UaException {
        try {
            return this.readFirstInGroupFlagAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeFirstInGroupFlag(Boolean value) throws UaException {
        try {
            this.writeFirstInGroupFlagAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Boolean> readFirstInGroupFlagAsync() {
        return ((CompletableFuture)this.getFirstInGroupFlagNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Boolean)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeFirstInGroupFlagAsync(Boolean firstInGroupFlag) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)firstInGroupFlag));
        return this.getFirstInGroupFlagNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getFirstInGroupFlagNode() throws UaException {
        try {
            return this.getFirstInGroupFlagNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getFirstInGroupFlagNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FirstInGroupFlag", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public AlarmGroupTypeNode getFirstInGroupNode() throws UaException {
        try {
            return this.getFirstInGroupNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends AlarmGroupTypeNode> getFirstInGroupNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "FirstInGroup", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (AlarmGroupTypeNode)node);
    }

    @Override
    public LocalizedText getLatchedState() throws UaException {
        TwoStateVariableTypeNode node = this.getLatchedStateNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setLatchedState(LocalizedText value) throws UaException {
        TwoStateVariableTypeNode node = this.getLatchedStateNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public LocalizedText readLatchedState() throws UaException {
        try {
            return this.readLatchedStateAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLatchedState(LocalizedText value) throws UaException {
        try {
            this.writeLatchedStateAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readLatchedStateAsync() {
        return ((CompletableFuture)this.getLatchedStateNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLatchedStateAsync(LocalizedText latchedState) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)latchedState));
        return this.getLatchedStateNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public TwoStateVariableTypeNode getLatchedStateNode() throws UaException {
        try {
            return this.getLatchedStateNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends TwoStateVariableTypeNode> getLatchedStateNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LatchedState", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (TwoStateVariableTypeNode)node);
    }

    @Override
    public Short getReAlarmRepeatCount() throws UaException {
        BaseDataVariableTypeNode node = this.getReAlarmRepeatCountNode();
        return (Short)node.getValue().getValue().getValue();
    }

    @Override
    public void setReAlarmRepeatCount(Short value) throws UaException {
        BaseDataVariableTypeNode node = this.getReAlarmRepeatCountNode();
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Short readReAlarmRepeatCount() throws UaException {
        try {
            return this.readReAlarmRepeatCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReAlarmRepeatCount(Short value) throws UaException {
        try {
            this.writeReAlarmRepeatCountAsync(value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Short> readReAlarmRepeatCountAsync() {
        return ((CompletableFuture)this.getReAlarmRepeatCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Short)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeReAlarmRepeatCountAsync(Short reAlarmRepeatCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)reAlarmRepeatCount));
        return this.getReAlarmRepeatCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getReAlarmRepeatCountNode() throws UaException {
        try {
            return this.getReAlarmRepeatCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getReAlarmRepeatCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReAlarmRepeatCount", ExpandedNodeId.parse((String)"ns=0;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

