/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.identity;

import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509IdentityProvider
implements IdentityProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<X509Certificate> certificateChain = Collections.synchronizedList(new ArrayList());
    private final PrivateKey privateKey;

    public X509IdentityProvider(X509Certificate certificate, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.certificateChain.add(certificate);
    }

    public X509IdentityProvider(List<X509Certificate> certificateChain, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.certificateChain.addAll(certificateChain);
    }

    @Override
    public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
        SignatureData signatureData;
        SecurityPolicy securityPolicy;
        UserTokenPolicy[] userIdentityTokens = Objects.requireNonNullElse(endpoint.getUserIdentityTokens(), new UserTokenPolicy[0]);
        UserTokenPolicy tokenPolicy = Stream.of(userIdentityTokens).filter(t -> t.getTokenType() == UserTokenType.Certificate).findFirst().orElseThrow(() -> new Exception("no x509 certificate token policy found"));
        String securityPolicyUri = tokenPolicy.getSecurityPolicyUri();
        try {
            if (securityPolicyUri == null || securityPolicyUri.isEmpty()) {
                securityPolicyUri = endpoint.getSecurityPolicyUri();
            }
            securityPolicy = SecurityPolicy.fromUri((String)securityPolicyUri);
        }
        catch (Throwable t2) {
            throw new UaException(0x80550000L, t2);
        }
        X509IdentityToken token = new X509IdentityToken(tokenPolicy.getPolicyId(), CertificateUtil.getCertificateChainBytes(this.certificateChain));
        if (securityPolicy == SecurityPolicy.None) {
            signatureData = new SignatureData(null, null);
        } else {
            NonceUtil.validateNonce((ByteString)serverNonce);
            List serverCertificates = CertificateUtil.decodeCertificates((byte[])endpoint.getServerCertificate().bytesOrEmpty());
            byte[] serverCertificateBytes = ((X509Certificate)serverCertificates.get(0)).getEncoded();
            byte[] serverNonceBytes = serverNonce.bytes();
            if (serverNonceBytes == null) {
                serverNonceBytes = new byte[]{};
            }
            byte[] signature = SignatureUtil.sign((SecurityAlgorithm)securityPolicy.getAsymmetricSignatureAlgorithm(), (PrivateKey)this.privateKey, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(serverCertificateBytes), ByteBuffer.wrap(serverNonceBytes)});
            signatureData = new SignatureData(securityPolicy.getAsymmetricSignatureAlgorithm().getUri(), ByteString.of((byte[])signature));
        }
        return new SignedIdentityToken((UserIdentityToken)token, signatureData);
    }
}

