/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessLevelExType;
import org.eclipse.milo.opcua.stack.core.types.structured.AccessRestrictionType;
import org.eclipse.milo.opcua.stack.core.types.structured.RolePermissionType;

public class VariableTypeManager {
    private final ConcurrentMap<NodeId, VariableTypeDefinition> typeDefinitions = new ConcurrentHashMap<NodeId, VariableTypeDefinition>();

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor variableNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, variableNodeConstructor));
    }

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, final LegacyVariableNodeConstructor variableNodeConstructor) {
        VariableNodeConstructor adapted = new VariableNodeConstructor(){

            @Override
            public UaVariableNode apply(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, RolePermissionType[] rolePermissions, RolePermissionType[] userRolePermissions, AccessRestrictionType accessRestrictions, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing, AccessLevelExType accessLevelEx) {
                return variableNodeConstructor.apply(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
            }
        };
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, adapted));
    }

    public Optional<VariableNodeConstructor> getNodeConstructor(NodeId typeDefinition) {
        VariableTypeDefinition def = (VariableTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeConstructor);
    }

    private static class VariableTypeDefinition {
        final Class<? extends UaVariableNode> nodeClass;
        final VariableNodeConstructor nodeConstructor;

        private VariableTypeDefinition(Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor nodeConstructor) {
            this.nodeClass = nodeClass;
            this.nodeConstructor = nodeConstructor;
        }
    }

    @FunctionalInterface
    public static interface VariableNodeConstructor {
        public UaVariableNode apply(OpcUaClient var1, NodeId var2, NodeClass var3, QualifiedName var4, LocalizedText var5, LocalizedText var6, UInteger var7, UInteger var8, RolePermissionType[] var9, RolePermissionType[] var10, AccessRestrictionType var11, DataValue var12, NodeId var13, Integer var14, UInteger[] var15, UByte var16, UByte var17, Double var18, Boolean var19, AccessLevelExType var20);
    }

    @FunctionalInterface
    public static interface LegacyVariableNodeConstructor {
        public UaVariableNode apply(OpcUaClient var1, NodeId var2, NodeClass var3, QualifiedName var4, LocalizedText var5, LocalizedText var6, UInteger var7, UInteger var8, DataValue var9, NodeId var10, Integer var11, UInteger[] var12, UByte var13, UByte var14, Double var15, Boolean var16);
    }
}

