/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class OpcUaClientConfigBuilder {
    private EndpointDescription endpoint;
    private List<EndpointDescription> discoveryEndpoints;
    private KeyPair keyPair;
    private X509Certificate certificate;
    private X509Certificate[] certificateChain;
    private CertificateValidator certificateValidator = new CertificateValidator.InsecureCertificateValidator();
    private LocalizedText applicationName = LocalizedText.english((String)"Eclipse Milo application name not configured");
    private String applicationUri = "urn:eclipse:milo:client:applicationUriNotConfigured";
    private String productUri = "https://github.com/eclipse-milo/milo";
    private Supplier<String> sessionName;
    private String[] sessionLocaleIds = new String[0];
    private UInteger sessionTimeout = Unsigned.uint((int)120000);
    private UInteger requestTimeout = Unsigned.uint((int)60000);
    private IdentityProvider identityProvider = new AnonymousProvider();
    private EncodingLimits encodingLimits = EncodingLimits.DEFAULT;
    private UInteger maxResponseMessageSize = Unsigned.uint((int)0);
    private UInteger maxPendingPublishRequests = Unsigned.uint((long)0xFFFFFFFFL);
    private UInteger keepAliveFailuresAllowed = Unsigned.uint((int)1);
    private UInteger keepAliveInterval = Unsigned.uint((int)5000);
    private UInteger keepAliveTimeout = Unsigned.uint((int)5000);
    private boolean sessionEndpointValidationEnabled = false;

    public OpcUaClientConfigBuilder setApplicationName(LocalizedText applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public OpcUaClientConfigBuilder setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
        return this;
    }

    public OpcUaClientConfigBuilder setProductUri(String productUri) {
        this.productUri = productUri;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionName(Supplier<String> sessionName) {
        this.sessionName = sessionName;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionLocaleIds(String[] sessionLocaleIds) {
        this.sessionLocaleIds = sessionLocaleIds;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionTimeout(UInteger sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setRequestTimeout(UInteger requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setEncodingLimits(EncodingLimits encodingLimits) {
        this.encodingLimits = encodingLimits;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxResponseMessageSize(UInteger maxResponseMessageSize) {
        this.maxResponseMessageSize = maxResponseMessageSize;
        return this;
    }

    public OpcUaClientConfigBuilder setMaxPendingPublishRequests(UInteger maxPendingPublishRequests) {
        this.maxPendingPublishRequests = maxPendingPublishRequests;
        return this;
    }

    public OpcUaClientConfigBuilder setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveFailuresAllowed(UInteger keepAliveFailuresAllowed) {
        this.keepAliveFailuresAllowed = keepAliveFailuresAllowed;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveInterval(UInteger keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    public OpcUaClientConfigBuilder setKeepAliveTimeout(UInteger keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    public OpcUaClientConfigBuilder setSessionEndpointValidationEnabled(boolean validateSessionEndpointsEnabled) {
        this.sessionEndpointValidationEnabled = validateSessionEndpointsEnabled;
        return this;
    }

    public OpcUaClientConfigBuilder setEndpoint(EndpointDescription endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public OpcUaClientConfigBuilder setDiscoveryEndpoints(List<EndpointDescription> discoveryEndpoints) {
        this.discoveryEndpoints = discoveryEndpoints;
        return this;
    }

    public OpcUaClientConfigBuilder setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public OpcUaClientConfigBuilder setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        return this;
    }

    public OpcUaClientConfigBuilder setCertificateChain(X509Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
        return this;
    }

    public OpcUaClientConfigBuilder setCertificateValidator(CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
        return this;
    }

    public OpcUaClientConfig build() {
        if (this.sessionName == null) {
            this.sessionName = () -> String.format("UaSession:%s:%s", this.applicationName.text(), System.currentTimeMillis());
        }
        return new OpcUaClientConfigImpl(this.endpoint, this.discoveryEndpoints, this.keyPair, this.certificate, this.certificateChain, this.certificateValidator, this.applicationName, this.applicationUri, this.productUri, this.sessionName, this.sessionLocaleIds, this.sessionTimeout, this.requestTimeout, this.encodingLimits, this.maxResponseMessageSize, this.maxPendingPublishRequests, this.identityProvider, this.keepAliveFailuresAllowed, this.keepAliveInterval, this.keepAliveTimeout, this.sessionEndpointValidationEnabled);
    }

    static class OpcUaClientConfigImpl
    implements OpcUaClientConfig {
        private final EndpointDescription endpoint;
        private final List<EndpointDescription> discoveryEndpoints;
        private final KeyPair keyPair;
        private final X509Certificate certificate;
        private final X509Certificate[] certificateChain;
        private final CertificateValidator certificateValidator;
        private final LocalizedText applicationName;
        private final String applicationUri;
        private final String productUri;
        private final Supplier<String> sessionName;
        private final String[] sessionLocaleIds;
        private final UInteger sessionTimeout;
        private final UInteger requestTimeout;
        private final EncodingLimits encodingLimits;
        private final UInteger maxResponseMessageSize;
        private final UInteger maxPendingPublishRequests;
        private final IdentityProvider identityProvider;
        private final UInteger keepAliveFailuresAllowed;
        private final UInteger keepAliveInterval;
        private final UInteger keepAliveTimeout;
        private final boolean sessionEndpointValidationEnabled;

        OpcUaClientConfigImpl(EndpointDescription endpoint, List<EndpointDescription> discoveryEndpoints, KeyPair keyPair, X509Certificate certificate, X509Certificate[] certificateChain, CertificateValidator certificateValidator, LocalizedText applicationName, String applicationUri, String productUri, Supplier<String> sessionName, String[] sessionLocaleIds, UInteger sessionTimeout, UInteger requestTimeout, EncodingLimits encodingLimits, UInteger maxResponseMessageSize, UInteger maxPendingPublishRequests, IdentityProvider identityProvider, UInteger keepAliveFailuresAllowed, UInteger keepAliveInterval, UInteger keepAliveTimeout, boolean sessionEndpointValidationEnabled) {
            this.endpoint = endpoint;
            this.discoveryEndpoints = discoveryEndpoints;
            this.keyPair = keyPair;
            this.certificate = certificate;
            this.certificateChain = certificateChain;
            this.certificateValidator = certificateValidator;
            this.applicationName = applicationName;
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.sessionName = sessionName;
            this.sessionLocaleIds = sessionLocaleIds;
            this.sessionTimeout = sessionTimeout;
            this.requestTimeout = requestTimeout;
            this.encodingLimits = encodingLimits;
            this.maxResponseMessageSize = maxResponseMessageSize;
            this.maxPendingPublishRequests = maxPendingPublishRequests;
            this.identityProvider = identityProvider;
            this.keepAliveFailuresAllowed = keepAliveFailuresAllowed;
            this.keepAliveInterval = keepAliveInterval;
            this.keepAliveTimeout = keepAliveTimeout;
            this.sessionEndpointValidationEnabled = sessionEndpointValidationEnabled;
        }

        @Override
        public EndpointDescription getEndpoint() {
            return this.endpoint;
        }

        @Override
        public List<EndpointDescription> getDiscoveryEndpoints() {
            return this.discoveryEndpoints;
        }

        @Override
        public Optional<KeyPair> getKeyPair() {
            return Optional.ofNullable(this.keyPair);
        }

        @Override
        public Optional<X509Certificate> getCertificate() {
            return Optional.ofNullable(this.certificate);
        }

        @Override
        public Optional<X509Certificate[]> getCertificateChain() {
            return Optional.ofNullable(this.certificateChain);
        }

        @Override
        public CertificateValidator getCertificateValidator() {
            return this.certificateValidator;
        }

        @Override
        public LocalizedText getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getApplicationUri() {
            return this.applicationUri;
        }

        @Override
        public String getProductUri() {
            return this.productUri;
        }

        @Override
        public Supplier<String> getSessionName() {
            return this.sessionName;
        }

        @Override
        public String[] getSessionLocaleIds() {
            return this.sessionLocaleIds;
        }

        @Override
        public UInteger getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Override
        public UInteger getRequestTimeout() {
            return this.requestTimeout;
        }

        @Override
        public EncodingLimits getEncodingLimits() {
            return this.encodingLimits;
        }

        @Override
        public UInteger getMaxResponseMessageSize() {
            return this.maxResponseMessageSize;
        }

        @Override
        public UInteger getMaxPendingPublishRequests() {
            return this.maxPendingPublishRequests;
        }

        @Override
        public IdentityProvider getIdentityProvider() {
            return this.identityProvider;
        }

        @Override
        public UInteger getKeepAliveFailuresAllowed() {
            return this.keepAliveFailuresAllowed;
        }

        @Override
        public UInteger getKeepAliveInterval() {
            return this.keepAliveInterval;
        }

        @Override
        public UInteger getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        @Override
        public boolean isSessionEndpointValidationEnabled() {
            return this.sessionEndpointValidationEnabled;
        }
    }
}

