/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.dtd;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.dtd.BinaryDataTypeCodec;
import org.eclipse.milo.opcua.sdk.core.dtd.BinaryDataTypeDictionary;
import org.eclipse.milo.opcua.sdk.core.dtd.BsdGenerator;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.server.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.model.objects.DataTypeEncodingTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.DataTypeDescriptionTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.variables.DataTypeDictionaryType;
import org.eclipse.milo.opcua.sdk.server.model.variables.DataTypeDictionaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.stack.core.NodeIds;
import org.eclipse.milo.opcua.stack.core.encoding.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.StructureType;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumField;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureField;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.shaded.com.google.common.base.Preconditions;
import org.opcfoundation.opcua.binaryschema.ByteOrder;
import org.opcfoundation.opcua.binaryschema.EnumeratedType;
import org.opcfoundation.opcua.binaryschema.EnumeratedValue;
import org.opcfoundation.opcua.binaryschema.FieldType;
import org.opcfoundation.opcua.binaryschema.ImportDirective;
import org.opcfoundation.opcua.binaryschema.StructuredType;
import org.opcfoundation.opcua.binaryschema.TypeDescription;
import org.opcfoundation.opcua.binaryschema.TypeDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDataTypeDictionaryManager
implements Lifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UaNode> nodes = new CopyOnWriteArrayList<UaNode>();
    private final Lazy<File> dictionaryFile = new Lazy();
    private final Map<NodeId, StructureDescription> structureDescriptions = new ConcurrentHashMap<NodeId, StructureDescription>();
    private final BinaryDataTypeDictionary dataTypeDictionary;
    private DataTypeDictionaryTypeNode dictionaryNode;
    private final TypeDictionary bsdTypeDictionary;
    private final UaNodeContext context;
    private final String namespaceUri;

    public BinaryDataTypeDictionaryManager(UaNodeContext context, String namespaceUri) {
        this.context = context;
        this.namespaceUri = namespaceUri;
        this.bsdTypeDictionary = new TypeDictionary();
        this.bsdTypeDictionary.setTargetNamespace(namespaceUri);
        this.bsdTypeDictionary.setDefaultByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.dataTypeDictionary = new BinaryDataTypeDictionary(this.bsdTypeDictionary);
    }

    private UaNodeManager getNodeManager() {
        return (UaNodeManager)this.context.getNodeManager();
    }

    public void startup() {
        this.context.getServer().getStaticDataTypeManager().registerTypeDictionary((DataTypeDictionary)this.dataTypeDictionary);
        this.dictionaryNode = new DataTypeDictionaryTypeNode(this.context, this.newNodeId(this.namespaceUri), this.newQualifiedName(this.namespaceUri), LocalizedText.english((String)this.namespaceUri), LocalizedText.english((String)("DataTypeDictionary for " + this.namespaceUri)), Unsigned.uint((int)0), Unsigned.uint((int)0), null, null, null, new DataValue(Variant.NULL_VALUE), NodeIds.BaseDataType, Integer.valueOf(-1), null);
        this.dictionaryNode.setNamespaceUri(this.namespaceUri);
        this.dictionaryNode.getFilterChain().addLast(AttributeFilters.getValue(context -> {
            try {
                File file = (File)this.dictionaryFile.get(() -> {
                    try {
                        return this.writeDictionaryToFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("failed to write dictionary file", e);
                    }
                });
                assert (file != null);
                try {
                    byte[] bs = Files.readAllBytes(file.toPath());
                    return new DataValue(new Variant((Object)ByteString.of((byte[])bs)));
                }
                catch (IOException e) {
                    this.logger.warn("Failed to read dictionary file", (Throwable)e);
                    this.dictionaryFile.reset();
                    byte[] bs = this.writeDictionaryToMemory();
                    return new DataValue(new Variant((Object)ByteString.of((byte[])bs)));
                }
            }
            catch (Throwable t) {
                this.logger.warn("Failed to write dictionary file", t);
                return new DataValue(new Variant((Object)ByteString.NULL_VALUE));
            }
        }));
        this.dictionaryNode.addReference(new Reference(this.dictionaryNode.getNodeId(), NodeIds.HasTypeDefinition, NodeIds.DataTypeDictionaryType.expanded(), Reference.Direction.FORWARD));
        this.dictionaryNode.addReference(new Reference(this.dictionaryNode.getNodeId(), NodeIds.HasComponent, NodeIds.OPCBinarySchema_TypeSystem.expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)this.dictionaryNode);
    }

    public void shutdown() {
        this.dictionaryNode.delete();
        this.nodes.forEach(UaNode::delete);
        this.nodes.clear();
    }

    public BinaryDataTypeDictionary getDataTypeDictionary() {
        return this.dataTypeDictionary;
    }

    public void registerEnum(EnumDescription description) {
        EnumeratedType enumeratedType = this.createBsdEnumeratedType(description);
        this.dataTypeDictionary.addTypeDescription((TypeDescription)enumeratedType);
        this.bsdTypeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().add(enumeratedType);
        this.dictionaryFile.reset();
    }

    public void registerStructure(String name, NodeId dataTypeId, NodeId binaryEncodingId, BinaryDataTypeCodec codec, StructureDescription description) {
        BinaryDataTypeDictionary.BinaryType binaryType = new BinaryDataTypeDictionary.BinaryType(name, dataTypeId, binaryEncodingId, codec);
        this.dataTypeDictionary.registerType((DataTypeDictionary.Type)binaryType);
        this.structureDescriptions.put(description.getDataTypeId(), description);
        DataTypeDescriptionTypeNode descriptionNode = new DataTypeDescriptionTypeNode(this.context, this.newNodeId(String.format("%s.Description", description.getName().name())), this.newQualifiedName(description.getName().name()), LocalizedText.english((String)description.getName().name()), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0), null, null, null, new DataValue(Variant.NULL_VALUE), NodeIds.BaseDataType, Integer.valueOf(-1), null);
        descriptionNode.setValue(new DataValue(new Variant((Object)description.getName().name())));
        descriptionNode.setDataType(NodeIds.String);
        descriptionNode.addReference(new Reference(descriptionNode.getNodeId(), NodeIds.HasTypeDefinition, NodeIds.DataTypeDescriptionType.expanded(), Reference.Direction.FORWARD));
        descriptionNode.addReference(new Reference(descriptionNode.getNodeId(), NodeIds.HasComponent, this.dictionaryNode.getNodeId().expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)descriptionNode);
        DataTypeEncodingTypeNode dataTypeEncodingNode = new DataTypeEncodingTypeNode(this.context, binaryEncodingId, new QualifiedName(0, "Default Binary"), LocalizedText.english((String)"Default Binary"), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0), null, null, null);
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), NodeIds.HasTypeDefinition, NodeIds.DataTypeEncodingType.expanded(), Reference.Direction.FORWARD));
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), NodeIds.HasDescription, descriptionNode.getNodeId().expanded(), Reference.Direction.FORWARD));
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), NodeIds.HasEncoding, description.getDataTypeId().expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)dataTypeEncodingNode);
        StructuredType structuredType = this.createBsdStructuredType(description);
        this.dataTypeDictionary.addTypeDescription((TypeDescription)structuredType);
        this.bsdTypeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().add(structuredType);
        this.dictionaryFile.reset();
        this.context.getServer().getStaticDataTypeManager().registerType(dataTypeId, (DataTypeCodec)codec, binaryEncodingId, null, null);
    }

    private File writeDictionaryToFile() throws IOException {
        String encodedUri = URLEncoder.encode(this.namespaceUri, StandardCharsets.UTF_8);
        Path tempFilePath = Files.createTempFile(encodedUri, ".bsd.xml", new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(tempFilePath.toFile());){
            this.writeDictionaryToStream(fos);
            this.logger.info("Wrote dictionary for '{}' to {}", (Object)this.namespaceUri, (Object)tempFilePath);
        }
        return tempFilePath.toFile();
    }

    private byte[] writeDictionaryToMemory() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeDictionaryToStream(baos);
        return baos.toByteArray();
    }

    private void writeDictionaryToStream(OutputStream outputStream) throws IOException {
        try {
            BsdGenerator.generate((TypeDictionary)this.bsdTypeDictionary, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private UShort getNamespaceIndex() {
        return (UShort)this.context.getNamespaceTable().getIndex(this.namespaceUri);
    }

    private NodeId newNodeId(String id) {
        return new NodeId(this.getNamespaceIndex(), id);
    }

    private QualifiedName newQualifiedName(String name) {
        return new QualifiedName(this.getNamespaceIndex(), name);
    }

    private void addNode(UaNode node) {
        this.getNodeManager().addNode((Node)node);
        this.nodes.add(node);
    }

    private EnumeratedType createBsdEnumeratedType(EnumDescription description) {
        QualifiedName name = description.getName();
        EnumDefinition definition = description.getEnumDefinition();
        EnumeratedType enumeratedType = new EnumeratedType();
        enumeratedType.setName(name.name());
        enumeratedType.setLengthInBits(Integer.valueOf(32));
        for (EnumField field : Objects.requireNonNullElse(definition.getFields(), new EnumField[0])) {
            EnumeratedValue enumeratedValue = new EnumeratedValue();
            enumeratedValue.setName(field.getName());
            enumeratedValue.setValue(Integer.valueOf(field.getValue().intValue()));
            enumeratedType.getEnumeratedValue().add(enumeratedValue);
        }
        return enumeratedType;
    }

    private StructuredType createBsdStructuredType(StructureDescription description) {
        QualifiedName name = description.getName();
        StructureDefinition definition = description.getStructureDefinition();
        StructureType structureType = definition.getStructureType();
        StructuredType structuredType = new StructuredType();
        structuredType.setName(name.name());
        LinkedList<StructureDefinition> definitions = new LinkedList<StructureDefinition>();
        definitions.addFirst(definition);
        NodeId baseDataTypeId = definition.getBaseDataType();
        while (baseDataTypeId != null && baseDataTypeId.isNotNull() && !NodeIds.Structure.equals((Object)baseDataTypeId) && !NodeIds.Union.equals((Object)baseDataTypeId)) {
            StructureDescription baseDescription = this.structureDescriptions.get(baseDataTypeId);
            StructureDefinition baseDefinition = baseDescription.getStructureDefinition();
            definitions.addFirst(baseDefinition);
            baseDataTypeId = baseDefinition.getBaseDataType();
        }
        LinkedHashMap<String, Object> allFields = new LinkedHashMap<String, Object>();
        for (StructureDefinition d : definitions) {
            for (StructureField f : Objects.requireNonNullElse(d.getFields(), new StructureField[0])) {
                allFields.put(f.getName(), f);
            }
        }
        ArrayList fields = new ArrayList(allFields.values());
        if (structureType == StructureType.StructureWithOptionalFields) {
            int optionalFieldCount = 0;
            for (StructureField field : fields) {
                if (!field.getIsOptional().booleanValue()) continue;
                ++optionalFieldCount;
                FieldType fieldType = new FieldType();
                fieldType.setName(field.getName() + "Present");
                fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Bit"));
                structuredType.getField().add(fieldType);
            }
            if (optionalFieldCount > 0) {
                int reservedFieldCount = (optionalFieldCount + 31) / 32;
                for (int i = 0; i < reservedFieldCount; ++i) {
                    long reservedBits = 32 - optionalFieldCount;
                    optionalFieldCount -= 32;
                    FieldType fieldType = new FieldType();
                    fieldType.setLength(Long.valueOf(reservedBits));
                    fieldType.setName("Reserved" + i);
                    fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Bit"));
                    structuredType.getField().add(fieldType);
                }
            }
        } else if (structureType == StructureType.Union) {
            FieldType fieldType = new FieldType();
            fieldType.setName("SwitchField");
            fieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "UInt32"));
            structuredType.getField().add(fieldType);
        }
        long switchValue = 0L;
        for (StructureField field : fields) {
            boolean registeredNamespace;
            String fieldName = field.getName();
            NodeId fieldDataTypeId = field.getDataType();
            QualifiedTypeName qualifiedTypeName = this.getDataTypeLocation(fieldDataTypeId);
            String dataTypeName = qualifiedTypeName.dataTypeName;
            String dictionaryNamespaceUri = qualifiedTypeName.dictionaryNamespaceUri;
            if (!dictionaryNamespaceUri.isEmpty() && !(registeredNamespace = this.bsdTypeDictionary.getImport().stream().anyMatch(id -> Objects.equals(id.getNamespace(), dictionaryNamespaceUri)))) {
                ImportDirective importDirective = new ImportDirective();
                importDirective.setNamespace(dictionaryNamespaceUri);
                this.bsdTypeDictionary.getImport().add(importDirective);
            }
            FieldType fieldType = new FieldType();
            fieldType.setName(fieldName);
            if (dictionaryNamespaceUri.isEmpty()) {
                fieldType.setTypeName(new QName(this.namespaceUri, dataTypeName));
            } else {
                fieldType.setTypeName(new QName(dictionaryNamespaceUri, dataTypeName));
            }
            if (structureType == StructureType.StructureWithOptionalFields) {
                if (field.getIsOptional().booleanValue()) {
                    fieldType.setSwitchField(fieldName + "Present");
                }
            } else if (structureType == StructureType.Union) {
                fieldType.setSwitchField("SwitchField");
                fieldType.setSwitchValue(Long.valueOf(++switchValue));
            }
            if (field.getValueRank() >= 1) {
                FieldType lengthFieldType = new FieldType();
                lengthFieldType.setName(fieldName + "Length");
                lengthFieldType.setTypeName(new QName("http://opcfoundation.org/BinarySchema/", "Int32"));
                if (structureType == StructureType.StructureWithOptionalFields) {
                    if (field.getIsOptional().booleanValue()) {
                        lengthFieldType.setSwitchField(fieldName + "Present");
                    }
                } else if (structureType == StructureType.Union) {
                    fieldType.setSwitchField("SwitchField");
                    fieldType.setSwitchValue(Long.valueOf(switchValue));
                }
                structuredType.getField().add(lengthFieldType);
                fieldType.setLengthField(fieldName + "Length");
            } else if (field.getValueRank() != -1) {
                throw new IllegalArgumentException("cannot encode field \"" + fieldName + "\" with ValueRank: %s" + field.getValueRank());
            }
            structuredType.getField().add(fieldType);
        }
        return structuredType;
    }

    private QualifiedTypeName getDataTypeLocation(NodeId dataTypeId) {
        AddressSpaceManager addressSpaceManager = this.context.getServer().getAddressSpaceManager();
        UaNode dataTypeNode = addressSpaceManager.getManagedNode(dataTypeId).orElse(null);
        Preconditions.checkNotNull((Object)dataTypeNode, (Object)("dataTypeNode for dataTypeId=" + String.valueOf(dataTypeId)));
        if (dataTypeId.getNamespaceIndex().intValue() == 0) {
            long id = ((UInteger)dataTypeId.getIdentifier()).longValue();
            String uri = id <= 15L ? "http://opcfoundation.org/BinarySchema/" : "http://opcfoundation.org/UA/";
            return new QualifiedTypeName(uri, dataTypeNode.getBrowseName().name());
        }
        QualifiedName parentTypeName = dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> addressSpaceManager.getManagedNode(r.getTargetNodeId()).stream()).findFirst().map(UaNode::getBrowseName).orElse(QualifiedName.NULL_VALUE);
        if (parentTypeName.equals((Object)new QualifiedName(0, "Enumeration"))) {
            return new QualifiedTypeName("", dataTypeNode.getBrowseName().name());
        }
        UaNode dataTypeEncodingNode = dataTypeNode.getReferences().stream().filter(Reference.HAS_ENCODING_PREDICATE).flatMap(r -> addressSpaceManager.getManagedNode(r.getTargetNodeId()).stream()).filter(n -> n.getBrowseName().equals((Object)new QualifiedName(0, "Default Binary"))).findFirst().orElse(null);
        Preconditions.checkNotNull((Object)dataTypeEncodingNode, (Object)("dataTypeEncodingNode for dataTypeId=" + String.valueOf(dataTypeId)));
        UaNode dataTypeDescriptionNode = dataTypeEncodingNode.getReferences().stream().filter(Reference.HAS_DESCRIPTION_PREDICATE).flatMap(r -> addressSpaceManager.getManagedNode(r.getTargetNodeId()).stream()).findFirst().orElse(null);
        Preconditions.checkNotNull((Object)dataTypeDescriptionNode, (Object)("dataTypeDescriptionNode for dataTypeId=" + String.valueOf(dataTypeId)));
        String dataTypeName = dataTypeDescriptionNode.getBrowseName().name();
        UaNode dictionaryNode = dataTypeDescriptionNode.getReferences().stream().filter(Reference.COMPONENT_OF_PREDICATE).flatMap(r -> addressSpaceManager.getManagedNode(r.getTargetNodeId()).stream()).findFirst().orElse(null);
        Preconditions.checkNotNull((Object)dictionaryNode, (Object)("dictionaryNode for dataTypeId=" + String.valueOf(dataTypeId)));
        String dictionaryNamespaceUri = dictionaryNode.getProperty(DataTypeDictionaryType.NAMESPACE_URI).orElse(null);
        Preconditions.checkNotNull((Object)dictionaryNamespaceUri, (Object)("dictionaryNamespaceUri for dataTypeId=" + String.valueOf(dataTypeId)));
        return new QualifiedTypeName(dictionaryNamespaceUri, dataTypeName);
    }

    public static class QualifiedTypeName {
        final String dictionaryNamespaceUri;
        final String dataTypeName;

        public QualifiedTypeName(String dictionaryNamespaceUri, String dataTypeName) {
            this.dictionaryNamespaceUri = dictionaryNamespaceUri;
            this.dataTypeName = dataTypeName;
        }
    }
}

