/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.dtd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.eclipse.milo.opcua.binaryschema.generator.DataTypeDictionaryGenerator;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceManager;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.DataTypeEncodingTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.DataTypeDescriptionTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.nodes.variables.DataTypeDictionaryTypeNode;
import org.eclipse.milo.opcua.sdk.server.model.types.variables.DataTypeDictionaryType;
import org.eclipse.milo.opcua.sdk.server.nodes.UaDataTypeNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaBinaryDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDescription;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeDictionaryManager
implements Lifecycle {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UaNode> nodes = new CopyOnWriteArrayList<UaNode>();
    private final Lazy<File> dictionaryFile = new Lazy();
    private final Map<NodeId, EnumDescription> enumDescriptions = Maps.newConcurrentMap();
    private final Map<NodeId, StructureDescription> structureDescriptions = Maps.newConcurrentMap();
    private final OpcUaBinaryDataTypeDictionary dictionary;
    private DataTypeDictionaryTypeNode dictionaryNode;
    private final UaNodeContext context;
    private final String namespaceUri;

    public DataTypeDictionaryManager(UaNodeContext context, String namespaceUri) {
        this.context = context;
        this.namespaceUri = namespaceUri;
        this.dictionary = new OpcUaBinaryDataTypeDictionary(namespaceUri);
    }

    private UaNodeContext getNodeContext() {
        return this.context;
    }

    private UaNodeManager getNodeManager() {
        return (UaNodeManager)this.getNodeContext().getNodeManager();
    }

    public void startup() {
        this.getNodeContext().getServer().getDataTypeManager().registerTypeDictionary((DataTypeDictionary)this.dictionary);
        this.dictionaryNode = new DataTypeDictionaryTypeNode(this.getNodeContext(), this.newNodeId(this.namespaceUri), this.newQualifiedName(this.namespaceUri), LocalizedText.english((String)this.namespaceUri), LocalizedText.english((String)("DataTypeDictionary for " + this.namespaceUri)), Unsigned.uint((int)0), Unsigned.uint((int)0));
        this.dictionaryNode.setNamespaceUri(this.namespaceUri);
        this.dictionaryNode.getFilterChain().addLast(AttributeFilters.getValue(context -> {
            try {
                File file = (File)this.dictionaryFile.getOrCompute(() -> {
                    try {
                        return this.writeDictionaryToFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("failed to write dictionary file", e);
                    }
                });
                assert (file != null);
                try {
                    byte[] bs = Files.readAllBytes(file.toPath());
                    return new DataValue(new Variant((Object)ByteString.of((byte[])bs)));
                }
                catch (IOException e) {
                    this.logger.warn("Failed to read dictionary file", (Throwable)e);
                    this.dictionaryFile.reset();
                    byte[] bs = this.writeDictionaryToMemory();
                    return new DataValue(new Variant((Object)ByteString.of((byte[])bs)));
                }
            }
            catch (Throwable t) {
                this.logger.warn("Failed to write dictionary file", t);
                return new DataValue(new Variant((Object)ByteString.NULL_VALUE));
            }
        }));
        this.dictionaryNode.addReference(new Reference(this.dictionaryNode.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.DataTypeDictionaryType.expanded(), Reference.Direction.FORWARD));
        this.dictionaryNode.addReference(new Reference(this.dictionaryNode.getNodeId(), Identifiers.HasComponent, Identifiers.OPCBinarySchema_TypeSystem.expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)this.dictionaryNode);
    }

    public void shutdown() {
        this.dictionaryNode.delete();
        this.nodes.forEach(UaNode::delete);
        this.nodes.clear();
    }

    public OpcUaBinaryDataTypeDictionary getDictionary() {
        return this.dictionary;
    }

    public void registerEnumCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId) {
        this.dictionary.registerEnumCodec(codec, description, dataTypeId);
        UaDataTypeNode dataTypeNode = new UaDataTypeNode(this.getNodeContext(), dataTypeId, this.newQualifiedName(description), LocalizedText.english((String)description), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0), false);
        dataTypeNode.addReference(new Reference(dataTypeId, Identifiers.HasSubtype, Identifiers.Enumeration.expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)dataTypeNode);
        this.getNodeContext().getServer().getDataTypeManager().registerTypeDictionary((DataTypeDictionary)this.dictionary);
    }

    public void registerEnumDescription(EnumDescription description) {
        this.enumDescriptions.put(description.getDataTypeId(), description);
        this.dictionaryFile.reset();
    }

    public void registerOptionSetCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId binaryEncodingId) {
        this.registerStructureCodec(codec, description, dataTypeId, binaryEncodingId, Identifiers.OptionSet);
    }

    public void registerStructureCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId binaryEncodingId) {
        this.registerStructureCodec(codec, description, dataTypeId, binaryEncodingId, Identifiers.Structure);
    }

    public void registerUnionCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId binaryEncodingId) {
        this.registerStructureCodec(codec, description, dataTypeId, binaryEncodingId, Identifiers.Union);
    }

    public void registerStructureCodec(OpcUaBinaryDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId binaryEncodingId, NodeId parentType) {
        this.dictionary.registerStructCodec(codec, description, dataTypeId, binaryEncodingId);
        UaDataTypeNode dataTypeNode = new UaDataTypeNode(this.getNodeContext(), dataTypeId, this.newQualifiedName(description), LocalizedText.english((String)description), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0), false);
        dataTypeNode.addReference(new Reference(dataTypeId, Identifiers.HasSubtype, parentType.expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)dataTypeNode);
        this.getNodeContext().getServer().getDataTypeManager().registerTypeDictionary((DataTypeDictionary)this.dictionary);
    }

    public void registerStructureDescription(StructureDescription description, NodeId binaryEncodingId) {
        this.structureDescriptions.put(description.getDataTypeId(), description);
        DataTypeDescriptionTypeNode descriptionNode = new DataTypeDescriptionTypeNode(this.getNodeContext(), this.newNodeId(String.format("%s.Description", description.getName())), this.newQualifiedName(description.getName().getName()), LocalizedText.english((String)description.getName().getName()), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0));
        descriptionNode.setValue(new DataValue(new Variant((Object)description.getName().getName())));
        descriptionNode.setDataType(Identifiers.String);
        descriptionNode.addReference(new Reference(descriptionNode.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.DataTypeDescriptionType.expanded(), Reference.Direction.FORWARD));
        descriptionNode.addReference(new Reference(descriptionNode.getNodeId(), Identifiers.HasComponent, this.dictionaryNode.getNodeId().expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)descriptionNode);
        DataTypeEncodingTypeNode dataTypeEncodingNode = new DataTypeEncodingTypeNode(this.getNodeContext(), binaryEncodingId, new QualifiedName(0, "Default Binary"), LocalizedText.english((String)"Default Binary"), LocalizedText.NULL_VALUE, Unsigned.uint((int)0), Unsigned.uint((int)0));
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), Identifiers.HasTypeDefinition, Identifiers.DataTypeEncodingType.expanded(), Reference.Direction.FORWARD));
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), Identifiers.HasDescription, descriptionNode.getNodeId().expanded(), Reference.Direction.FORWARD));
        dataTypeEncodingNode.addReference(new Reference(dataTypeEncodingNode.getNodeId(), Identifiers.HasEncoding, description.getDataTypeId().expanded(), Reference.Direction.INVERSE));
        this.addNode((UaNode)dataTypeEncodingNode);
        this.dictionaryFile.reset();
    }

    private File writeDictionaryToFile() throws IOException {
        String encodedUri = URLEncoder.encode(this.namespaceUri, StandardCharsets.UTF_8.name());
        Path tempFilePath = Files.createTempFile(encodedUri, ".bsd.xml", new FileAttribute[0]);
        try (FileOutputStream fos = new FileOutputStream(tempFilePath.toFile());){
            this.writeDictionaryToStream(fos);
            this.logger.info("Wrote dictionary for '{}' to {}", (Object)this.namespaceUri, (Object)tempFilePath);
        }
        return tempFilePath.toFile();
    }

    private byte[] writeDictionaryToMemory() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeDictionaryToStream(baos);
        return baos.toByteArray();
    }

    private void writeDictionaryToStream(OutputStream outputStream) throws IOException {
        DataTypeDictionaryGenerator generator = DataTypeDictionaryManager.newDictionaryGenerator(this.namespaceUri, this.getNodeContext().getServer().getAddressSpaceManager());
        this.enumDescriptions.values().forEach(description -> {
            try {
                generator.addEnumDescription(description);
            }
            catch (Throwable t) {
                this.logger.warn("Failed to add EnumDescription: " + description.getName(), t);
            }
        });
        this.structureDescriptions.values().forEach(description -> {
            try {
                generator.addStructureDescription(description);
            }
            catch (Throwable t) {
                this.logger.warn("Failed to add StructureDescription: " + description.getName(), t);
            }
        });
        generator.writeToOutputStream(outputStream);
    }

    private UShort getNamespaceIndex() {
        return this.getNodeContext().getNamespaceTable().getIndex(this.namespaceUri);
    }

    private NodeId newNodeId(String id) {
        return new NodeId(this.getNamespaceIndex(), id);
    }

    private QualifiedName newQualifiedName(String name) {
        return new QualifiedName(this.getNamespaceIndex(), name);
    }

    private void addNode(UaNode node) {
        this.getNodeManager().addNode((Node)node);
        this.nodes.add(node);
    }

    private static DataTypeDictionaryGenerator newDictionaryGenerator(String namespaceUri, AddressSpaceManager addressSpaceManager) {
        Function<NodeId, DataTypeDictionaryGenerator.DataTypeLocation> dataTypeLookup = dataTypeId -> {
            UaNode dataTypeNode = addressSpaceManager.getManagedNode(dataTypeId).orElse(null);
            Preconditions.checkNotNull((Object)dataTypeNode, (Object)("dataTypeNode for dataTypeId=" + dataTypeId));
            if (dataTypeId.getNamespaceIndex().intValue() == 0) {
                long id = ((UInteger)dataTypeId.getIdentifier()).longValue();
                String uri = id <= 15L ? "http://opcfoundation.org/BinarySchema/" : "http://opcfoundation.org/UA/";
                return new DataTypeDictionaryGenerator.DataTypeLocation(dataTypeNode.getBrowseName().getName(), uri);
            }
            QualifiedName parentTypeName = dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)addressSpaceManager.getManagedNode(r.getTargetNodeId()))).findFirst().map(UaNode::getBrowseName).orElse(QualifiedName.NULL_VALUE);
            if (parentTypeName.equals((Object)new QualifiedName(0, "Enumeration"))) {
                return new DataTypeDictionaryGenerator.DataTypeLocation(dataTypeNode.getBrowseName().getName(), "");
            }
            UaNode dataTypeEncodingNode = dataTypeNode.getReferences().stream().filter(Reference.HAS_ENCODING_PREDICATE).flatMap(r -> StreamUtil.opt2stream((Optional)addressSpaceManager.getManagedNode(r.getTargetNodeId()))).filter(n -> n.getBrowseName().equals((Object)new QualifiedName(0, "Default Binary"))).findFirst().orElse(null);
            Preconditions.checkNotNull((Object)dataTypeEncodingNode, (Object)("dataTypeEncodingNode for dataTypeId=" + dataTypeId));
            UaNode dataTypeDescriptionNode = dataTypeEncodingNode.getReferences().stream().filter(Reference.HAS_DESCRIPTION_PREDICATE).flatMap(r -> StreamUtil.opt2stream((Optional)addressSpaceManager.getManagedNode(r.getTargetNodeId()))).findFirst().orElse(null);
            Preconditions.checkNotNull((Object)dataTypeDescriptionNode, (Object)("dataTypeDescriptionNode for dataTypeId=" + dataTypeId));
            String dataTypeName = dataTypeDescriptionNode.getBrowseName().getName();
            UaNode dictionaryNode = dataTypeDescriptionNode.getReferences().stream().filter(Reference.COMPONENT_OF_PREDICATE).flatMap(r -> StreamUtil.opt2stream((Optional)addressSpaceManager.getManagedNode(r.getTargetNodeId()))).findFirst().orElse(null);
            Preconditions.checkNotNull((Object)dictionaryNode, (Object)("dictionaryNode for dataTypeId=" + dataTypeId));
            String dictionaryNamespaceUri = dictionaryNode.getProperty(DataTypeDictionaryType.NAMESPACE_URI).orElse(null);
            Preconditions.checkNotNull((Object)dictionaryNamespaceUri, (Object)("dictionaryNamespaceUri for dataTypeId=" + dataTypeId));
            return new DataTypeDictionaryGenerator.DataTypeLocation(dataTypeName, dictionaryNamespaceUri);
        };
        return new DataTypeDictionaryGenerator(namespaceUri, dataTypeLookup);
    }
}

