/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.binaryschema.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.milo.opcua.binaryschema.AbstractCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.opcfoundation.opcua.binaryschema.StructuredType;

public class JsonStructureCodec
extends AbstractCodec<JsonObject, JsonElement> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    JsonStructureCodec(StructuredType structuredType) {
        super(structuredType);
    }

    public Class<JsonObject> getType() {
        return JsonObject.class;
    }

    protected JsonObject createStructure(String name, LinkedHashMap<String, JsonElement> members) {
        JsonObject object = new JsonObject();
        members.forEach((arg_0, arg_1) -> ((JsonObject)object).add(arg_0, arg_1));
        return object;
    }

    protected JsonElement opcUaToMemberTypeScalar(String name, Object value, String typeName) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof String) {
            return new JsonPrimitive((String)value);
        }
        if (value instanceof Character) {
            return new JsonPrimitive((Character)value);
        }
        if (value instanceof JsonElement) {
            return (JsonElement)value;
        }
        if (value instanceof DateTime) {
            return new JsonPrimitive((Number)((DateTime)value).getUtcTime());
        }
        if (value instanceof UUID) {
            return new JsonPrimitive(value.toString());
        }
        if (value instanceof LocalizedText) {
            return this.gson.toJsonTree(value);
        }
        if (value instanceof QualifiedName) {
            return this.gson.toJsonTree(value);
        }
        if (value instanceof ByteString) {
            ByteString byteString = (ByteString)value;
            byte[] bs = byteString.bytesOrEmpty();
            JsonArray array = new JsonArray();
            byte[] byArray = bs;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte b = byArray[i];
                array.add((JsonElement)new JsonPrimitive((Number)b));
            }
            return array;
        }
        if (value instanceof XmlElement) {
            String fragment = ((XmlElement)value).getFragment();
            return fragment != null ? new JsonPrimitive(fragment) : JsonNull.INSTANCE;
        }
        if (value instanceof NodeId) {
            String nodeId = ((NodeId)value).toParseableString();
            return new JsonPrimitive(nodeId);
        }
        if (value instanceof ExpandedNodeId) {
            String xNodeId = ((ExpandedNodeId)value).toParseableString();
            return new JsonPrimitive(xNodeId);
        }
        if (value instanceof StatusCode) {
            long code = ((StatusCode)value).getValue();
            return new JsonPrimitive((Number)code);
        }
        throw new RuntimeException("could not create JsonElement for value: " + value);
    }

    protected JsonElement opcUaToMemberTypeArray(String name, Object values, String typeName) {
        JsonArray array = new JsonArray();
        if (values instanceof Object[]) {
            Object[] objects;
            for (Object value : objects = (Object[])values) {
                array.add(this.opcUaToMemberTypeScalar(name, value, typeName));
            }
        } else if (values instanceof Number) {
            Number number = (Number)values;
            return new JsonPrimitive(number);
        }
        return array;
    }

    protected Object memberTypeToOpcUaScalar(JsonElement member, String typeName) {
        if (member == null || member.isJsonNull()) {
            return null;
        }
        if (member.isJsonArray()) {
            JsonArray array = member.getAsJsonArray();
            switch (typeName) {
                case "ByteString": {
                    byte[] bs = new byte[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        bs[i] = array.get(i).getAsByte();
                    }
                    return ByteString.of((byte[])bs);
                }
            }
            return array;
        }
        if (member.isJsonObject()) {
            JsonObject jsonObject = member.getAsJsonObject();
            switch (typeName) {
                case "QualifiedName": {
                    return new QualifiedName(jsonObject.get("namespaceIndex").getAsInt(), jsonObject.get("name").getAsString());
                }
                case "LocalizedText": {
                    return new LocalizedText(jsonObject.get("locale").getAsString(), jsonObject.get("text").getAsString());
                }
            }
            return jsonObject;
        }
        if (member.isJsonPrimitive()) {
            JsonPrimitive primitive = member.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isString()) {
                switch (typeName) {
                    case "Guid": {
                        return UUID.fromString(primitive.getAsString());
                    }
                    case "NodeId": {
                        return NodeId.parseSafe((String)primitive.getAsString()).orElse(NodeId.NULL_VALUE);
                    }
                    case "ExpandedNodeId": {
                        return ExpandedNodeId.parse((String)primitive.getAsString());
                    }
                    case "XmlElement": {
                        return new XmlElement(primitive.getAsString());
                    }
                }
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                switch (typeName) {
                    case "SByte": {
                        return primitive.getAsByte();
                    }
                    case "Int16": {
                        return primitive.getAsShort();
                    }
                    case "Int32": {
                        return primitive.getAsInt();
                    }
                    case "Int64": {
                        return primitive.getAsLong();
                    }
                    case "Byte": {
                        return Unsigned.ubyte((short)primitive.getAsShort());
                    }
                    case "UInt16": {
                        return Unsigned.ushort((int)primitive.getAsInt());
                    }
                    case "UInt32": {
                        return Unsigned.uint((long)primitive.getAsLong());
                    }
                    case "UInt64": {
                        return Unsigned.ulong((BigInteger)primitive.getAsBigInteger());
                    }
                    case "Float": {
                        return Float.valueOf(primitive.getAsFloat());
                    }
                    case "Double": {
                        return primitive.getAsDouble();
                    }
                    case "DateTime": {
                        return new DateTime(primitive.getAsLong());
                    }
                    case "StatusCode": {
                        return new StatusCode(primitive.getAsLong());
                    }
                }
                return primitive.getAsNumber();
            }
        }
        return null;
    }

    protected Object memberTypeToOpcUaArray(JsonElement member, String typeName) {
        if ("Bit".equals(typeName)) {
            return member.getAsJsonPrimitive().getAsInt();
        }
        JsonArray array = member.getAsJsonArray();
        Object[] values = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            values[i] = this.memberTypeToOpcUaScalar(element, typeName);
        }
        return values;
    }

    protected Map<String, JsonElement> getMembers(JsonObject value) {
        LinkedHashMap<String, JsonElement> members = new LinkedHashMap<String, JsonElement>();
        value.entrySet().forEach(e -> {
            JsonElement cfr_ignored_0 = (JsonElement)members.put((String)e.getKey(), (JsonElement)e.getValue());
        });
        return members;
    }
}

