/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.io.IOException;
import java.net.URL;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.tck.interfaces.MissingPathParam;
import org.eclipse.microprofile.rest.client.tck.interfaces.MissingPathParamSub;
import org.eclipse.microprofile.rest.client.tck.interfaces.MissingUriTemplate;
import org.eclipse.microprofile.rest.client.tck.interfaces.MultipleHTTPMethodAnnotations;
import org.eclipse.microprofile.rest.client.tck.interfaces.TemplateMismatch;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class InvalidInterfaceTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return (Archive)ShrinkWrap.create(WebArchive.class, (String)(InvalidInterfaceTest.class.getSimpleName() + ".war"));
    }

    @Test(expectedExceptions={RestClientDefinitionException.class})
    public void testExceptionThrownWhenInterfaceHasMethodWithMultipleHTTPMethodAnnotations() throws IOException {
        RestClientBuilder.newBuilder().baseUrl(new URL("http://localhost:8080/")).build(MultipleHTTPMethodAnnotations.class);
    }

    @Test(expectedExceptions={RestClientDefinitionException.class})
    public void testExceptionThrownWhenInterfaceHasMethodWithMissingPathParamAnnotation_templateDeclaredAtTypeLevel() throws IOException {
        RestClientBuilder.newBuilder().baseUrl(new URL("http://localhost:8080/")).build(MissingPathParam.class);
    }

    @Test(expectedExceptions={RestClientDefinitionException.class})
    public void testExceptionThrownWhenInterfaceHasMethodWithMissingPathParamAnnotation_templateDeclaredAtMethodLevel() throws IOException {
        RestClientBuilder.newBuilder().baseUrl(new URL("http://localhost:8080/")).build(MissingPathParamSub.class);
    }

    @Test(expectedExceptions={RestClientDefinitionException.class})
    public void testExceptionThrownWhenInterfaceHasMethodWithPathParamAnnotationButNoURITemplate() throws IOException {
        RestClientBuilder.newBuilder().baseUrl(new URL("http://localhost:8080/")).build(MissingUriTemplate.class);
    }

    @Test(expectedExceptions={RestClientDefinitionException.class})
    public void testExceptionThrownWhenInterfaceHasMethodWithMismatchedPathParameter() throws IOException {
        RestClientBuilder.newBuilder().baseUrl(new URL("http://localhost:8080/")).build(TemplateMismatch.class);
    }
}

