/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Project;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractJKubeMojo
implements ManifestProvider {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/jkube/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/jkube/openshift.yml";
    @Parameter(property="jkube.recreate", defaultValue="false")
    protected boolean recreate;
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    protected File kubernetesManifest;
    @Parameter(property="jkube.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="jkube.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @Parameter(property="jkube.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="jkube.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="jkube.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="jkube.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="jkube.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="jkube.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="jkube.deploy.jsonLogDir", defaultValue="${basedir}/target/jkube/applyJson")
    private File jsonLogDir;
    @Parameter(property="jkube.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @Parameter
    protected ResourceConfig resources;
    @Parameter(property="jkube.resourceDir", defaultValue="${basedir}/src/main/jkube")
    private File resourceDir;
    @Parameter(property="jkube.environment")
    private String environment;
    @Parameter(property="jkube.skip.apply", defaultValue="false")
    protected boolean skipApply;
    protected ApplyService applyService;

    @Override
    protected boolean canExecute() {
        return super.canExecute() && !this.skipApply;
    }

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        try {
            KubernetesClient kubernetes = this.clusterAccess.createDefaultClient();
            this.applyService = new ApplyService(kubernetes, this.log);
            this.initServices(kubernetes);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = this.getManifest(kubernetes);
            if (!manifest.exists() || !manifest.isFile()) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            this.applyService.setAllowCreate(this.createNewResources);
            this.applyService.setServicesOnlyMode(this.servicesOnly);
            this.applyService.setIgnoreServiceMode(this.ignoreServices);
            this.applyService.setLogJsonDir(this.jsonLogDir);
            this.applyService.setBasedir(this.getRootProjectFolder());
            this.applyService.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            this.applyService.setProcessTemplatesLocally(this.processTemplatesLocally);
            this.applyService.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            this.applyService.setRollingUpgrade(this.rollingUpgrades);
            this.applyService.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            this.applyService.setRecreateMode(this.recreate);
            boolean openShift = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.log.info("[[B]]OpenShift[[B]] platform detected", new Object[0]);
            } else {
                this.disableOpenShiftFeatures(this.applyService);
            }
            Set entities = KubernetesResourceUtil.loadResources((File)manifest);
            String namespace = this.clusterAccess.getNamespace();
            boolean namespaceEntityExist = false;
            for (HasMetadata entity : entities) {
                if (entity instanceof Namespace) {
                    Namespace ns = (Namespace)entity;
                    namespace = ns.getMetadata().getName();
                    this.applyService.applyNamespace(ns);
                    namespaceEntityExist = true;
                    entities.remove(entity);
                    break;
                }
                if (!(entity instanceof Project)) continue;
                Project project = (Project)entity;
                namespace = project.getMetadata().getName();
                this.applyService.applyProject(project);
                namespaceEntityExist = true;
                entities.remove(entity);
                break;
            }
            if (!namespaceEntityExist) {
                this.applyService.applyNamespace(namespace);
            }
            this.applyService.setNamespace(namespace);
            this.applyEntities(kubernetes, namespace, manifest.getName(), entities);
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{this.clusterAccess.isOpenShift() ? "oc" : "kubectl"});
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (KitLogger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void initServices(KubernetesClient kubernetes) {
        this.log.debug("No services required in ApplyMojo", new Object[0]);
    }

    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                this.applyService.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                this.applyService.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                this.applyService.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            this.applyService.apply((Object)entity, fileName);
        }
        KitLogger serviceLogger = this.createLogger("[[G]][SVC][[G]] [[s]]");
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            Resource serviceResource = (Resource)((NonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && StringUtils.isNotBlank((CharSequence)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!StringUtils.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceLogger.info("%s: %s", new Object[]{name, url});
        }
        this.applyService.processCustomEntities(this.resources != null ? this.resources.getCustomResourceDefinitions() : null, this.resourceDir, this.environment, this.resources != null ? this.resources.getRemotes() : null);
    }

    protected String getExternalServiceURL(Service service) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)service).get(JKubeAnnotations.SERVICE_EXPOSE_URL.value());
    }

    protected boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.equalsIgnoreCase("true");
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(ApplyService applyService) {
        this.processTemplatesLocally = true;
        applyService.setSupportOAuthClients(false);
        applyService.setProcessTemplatesLocally(true);
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }
}

