/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.watcher.standard;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchException;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.access.ClusterAccess;
import org.eclipse.jkube.watcher.standard.ExecListenerLatch;

public class PodExecutor {
    private final ClusterAccess clusterAccess;
    private final Duration waitTimeout;
    private String output;

    public PodExecutor(ClusterAccess clusterAccess, Duration waitTimeout) {
        this.clusterAccess = clusterAccess;
        this.waitTimeout = waitTimeout;
    }

    void uploadChangedFilesToPod(Collection<HasMetadata> resources, File changedFilesTarball) throws WatchException {
        try (KubernetesClient client = this.clusterAccess.createDefaultClient();){
            String namespace = this.clusterAccess.getNamespace();
            File changedFilesDir = new File(changedFilesTarball.getParentFile(), "changed-files");
            File[] changedFiles = changedFilesDir.listFiles();
            if (changedFiles != null && changedFiles.length > 0) {
                PodResource podResource = (PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(KubernetesHelper.getNewestApplicationPodName((KubernetesClient)client, (String)namespace, resources));
                for (File changedFile : changedFiles) {
                    if (changedFile.isFile()) {
                        podResource.file("/" + FileUtil.getRelativeFilePath((String)changedFilesDir.getPath(), (String)changedFile.getPath())).upload(changedFile.toPath());
                        continue;
                    }
                    if (!changedFile.isDirectory()) continue;
                    podResource.dir("/" + FileUtil.getRelativeFilePath((String)changedFilesDir.getPath(), (String)changedFile.getPath())).upload(changedFile.toPath());
                }
            }
        }
        catch (KubernetesClientException kubernetesClientException) {
            throw new WatchException("Error while uploading changed files archive to pod: " + kubernetesClientException.getMessage());
        }
    }

    void executeCommandInPod(Collection<HasMetadata> resources, String command) throws InterruptedException, WatchException, IOException {
        try (KubernetesClient client = this.clusterAccess.createDefaultClient();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String namespace = this.clusterAccess.getNamespace();
            ExecListenerLatch latch = new ExecListenerLatch();
            ExecWatch execWatch = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(KubernetesHelper.getNewestApplicationPodName((KubernetesClient)client, (String)namespace, resources))).redirectingInput().writingOutput((OutputStream)byteArrayOutputStream).redirectingError().usingListener((ExecListener)latch).exec(new String[]{"sh", "-c", command});
            boolean completed = latch.await(this.waitTimeout.toMillis(), TimeUnit.MILLISECONDS);
            execWatch.close();
            this.output = byteArrayOutputStream.toString();
            if (!completed) {
                throw new WatchException("Command execution timed out");
            }
            if (latch.getCloseCode() != 1000) {
                throw new WatchException("Command execution socket closed unexpectedly " + latch.getCloseReason());
            }
            Status status = latch.getExitStatus();
            if (status.getStatus().equals("Failure")) {
                throw new WatchException("Command execution failed: " + status.getMessage());
            }
        }
        catch (KubernetesClientException e) {
            throw new WatchException("Execution failed due to a KubernetesClient error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getOutput() {
        return this.output;
    }
}

