/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.util.List;
import org.eclipse.jkube.generator.api.Generator;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class GeneratorManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/generator-default", "META-INF/jkube/jkube-generator-default", "META-INF/jkube/generator", "META-INF/jkube-generator"};

    private GeneratorManager() {
    }

    public static List<ImageConfiguration> generate(List<ImageConfiguration> imageConfigs, GeneratorContext genCtx, boolean prePackagePhase) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)genCtx, new ClassLoader[0]);
        if (genCtx.isUseProjectClasspath()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((List)genCtx.getProject().getCompileClassPathElements(), (KitLogger)genCtx.getLogger()));
        }
        List<ImageConfiguration> ret = imageConfigs;
        KitLogger log = genCtx.getLogger();
        List generators = pluginFactory.createServiceObjects(SERVICE_PATHS);
        List usableGenerators = genCtx.getConfig().prepareProcessors(generators, "generator");
        log.verbose("Generators:", new Object[0]);
        for (Generator generator : usableGenerators) {
            log.verbose(" - %s", new Object[]{generator.getName()});
            if (!generator.isApplicable(ret)) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret, prePackagePhase);
        }
        return ret;
    }
}

