/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.generator.api.DefaultImageLookup;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public abstract class FromSelector {
    private final GeneratorContext context;

    public FromSelector(GeneratorContext context) {
        this.context = context;
    }

    public String getFrom() {
        RuntimeMode mode = this.context.getRuntimeMode();
        JKubeBuildStrategy strategy = this.context.getStrategy();
        if (mode == RuntimeMode.OPENSHIFT && strategy == JKubeBuildStrategy.s2i) {
            return this.getS2iBuildFrom();
        }
        return this.getDockerBuildFrom();
    }

    public Map<String, String> getImageStreamTagFromExt() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(JKubeBuildStrategy.SourceStrategy.kind.key(), "ImageStreamTag");
        ret.put(JKubeBuildStrategy.SourceStrategy.namespace.key(), "openshift");
        ret.put(JKubeBuildStrategy.SourceStrategy.name.key(), this.getIstagFrom());
        return ret;
    }

    protected abstract String getDockerBuildFrom();

    protected abstract String getS2iBuildFrom();

    protected abstract String getIstagFrom();

    public static class Default
    extends FromSelector {
        private final String upstreamDocker;
        private final String upstreamS2i;
        private final String upstreamIstag;

        public Default(GeneratorContext context, String prefix) {
            super(context);
            DefaultImageLookup lookup = new DefaultImageLookup(Default.class);
            this.upstreamDocker = lookup.getImageName(prefix + ".upstream.docker");
            this.upstreamS2i = lookup.getImageName(prefix + ".upstream.s2i");
            this.upstreamIstag = lookup.getImageName(prefix + ".upstream.istag");
        }

        @Override
        protected String getDockerBuildFrom() {
            return this.upstreamDocker;
        }

        @Override
        protected String getS2iBuildFrom() {
            return this.upstreamS2i;
        }

        @Override
        protected String getIstagFrom() {
            return this.upstreamIstag;
        }
    }
}

