/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.config.resource.JKubeAnnotations;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class RouteEnricher
extends BaseEnricher {
    private static final String GENERATE_ROUTE_PROPERTY = "jkube.openshift.generateRoute";
    public static final String EXPOSE_LABEL = "expose";
    private String routeDomainPostfix;

    public RouteEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-openshift-route");
    }

    private boolean isGenerateRoute() {
        return Configs.asBoolean((String)this.getConfigWithFallback(Config.GENERATE_ROUTE, GENERATE_ROUTE_PROPERTY, null));
    }

    private boolean isRouteWithTLS() {
        return StringUtils.isNotBlank((CharSequence)this.getConfig(Config.TLS_TERMINATION, null));
    }

    public void create(PlatformMode platformMode, final KubernetesListBuilder listBuilder) {
        ResourceConfig resourceConfig = this.getConfiguration().getResource();
        if (resourceConfig != null && resourceConfig.getRouteDomain() != null) {
            this.routeDomainPostfix = resourceConfig.getRouteDomain();
        }
        if (platformMode == PlatformMode.openshift && this.isGenerateRoute()) {
            listBuilder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

                public void visit(ServiceBuilder serviceBuilder) {
                    RouteEnricher.this.addRoute(listBuilder, serviceBuilder);
                }
            });
        }
    }

    private void addRoute(KubernetesListBuilder listBuilder, ServiceBuilder serviceBuilder) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata != null && StringUtils.isNotBlank((CharSequence)serviceMetadata.getName()) && this.hasExactlyOneServicePort(serviceBuilder, serviceMetadata.getName()) && RouteEnricher.isExposedService(serviceMetadata)) {
            String name = serviceMetadata.getName();
            this.updateRouteDomainPostFixBasedOnServiceName(name);
            Route opinionatedRoute = RouteEnricher.createOpinionatedRouteFromService(serviceBuilder, this.routeDomainPostfix, this.getConfig(Config.TLS_TERMINATION, "edge"), this.getConfig(Config.TLS_INSECURE_EDGE_TERMINATION_POLICY, "Allow"), this.isRouteWithTLS());
            if (opinionatedRoute != null) {
                int routeFromFragmentIndex = RouteEnricher.getRouteIndexWithName(listBuilder, name);
                if (routeFromFragmentIndex >= 0) {
                    Route routeFragment = (Route)listBuilder.buildItems().get(routeFromFragmentIndex);
                    Route mergedRoute = RouteEnricher.mergeRoute(routeFragment, opinionatedRoute);
                    KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)listBuilder, (HasMetadata)((HasMetadata)listBuilder.getItems().get(routeFromFragmentIndex)));
                    listBuilder.addToItems(new HasMetadata[]{mergedRoute});
                } else {
                    listBuilder.addToItems(new HasMetadata[]{opinionatedRoute});
                }
            }
        }
    }

    private static RoutePort createRoutePort(ServiceBuilder serviceBuilder) {
        IntOrString targetPort;
        ServicePort servicePort;
        List ports;
        RoutePort routePort = null;
        ServiceSpec spec = serviceBuilder.buildSpec();
        if (spec != null && (ports = spec.getPorts()) != null && !ports.isEmpty() && (servicePort = (ServicePort)ports.get(0)) != null && (targetPort = servicePort.getTargetPort()) != null) {
            routePort = new RoutePort();
            routePort.setTargetPort(targetPort);
        }
        return routePort;
    }

    private String prepareHostForRoute(String routeDomainPostfix, String name) {
        String ret = FileUtil.stripPostfix((String)name, (String)"-service");
        ret = FileUtil.stripPostfix((String)ret, (String)".");
        ret = ret + ".";
        ret = ret + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
        return ret;
    }

    private Set<Integer> getPorts(ServiceBuilder service) {
        HashSet<Integer> answer = new HashSet<Integer>();
        if (service != null) {
            ServiceSpec spec = RouteEnricher.getOrCreateSpec(service);
            for (ServicePort port : spec.getPorts()) {
                answer.add(port.getPort());
            }
        }
        return answer;
    }

    public static ServiceSpec getOrCreateSpec(ServiceBuilder entity) {
        ServiceSpec spec = entity.buildSpec();
        if (spec == null) {
            spec = new ServiceSpec();
            entity.editOrNewSpec().endSpec();
        }
        return spec;
    }

    private boolean hasExactlyOneServicePort(ServiceBuilder service, String id) {
        Set<Integer> ports = this.getPorts(service);
        if (ports.size() != 1) {
            this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            return false;
        }
        return true;
    }

    private void updateRouteDomainPostFixBasedOnServiceName(String serviceName) {
        this.routeDomainPostfix = StringUtils.isNotBlank((CharSequence)this.routeDomainPostfix) ? this.prepareHostForRoute(this.routeDomainPostfix, serviceName) : "";
    }

    static Route mergeRoute(Route routeFromFragment, Route opinionatedRoute) {
        if (routeFromFragment.getApiVersion().equals("v1")) {
            routeFromFragment.setApiVersion(opinionatedRoute.getApiVersion());
        }
        KubernetesResourceUtil.mergeMetadata((HasMetadata)routeFromFragment, (HasMetadata)opinionatedRoute);
        if (routeFromFragment.getSpec() != null) {
            routeFromFragment.setSpec(RouteEnricher.mergeRouteSpec(routeFromFragment.getSpec(), opinionatedRoute.getSpec()));
        } else {
            routeFromFragment.setSpec(opinionatedRoute.getSpec());
        }
        return routeFromFragment;
    }

    static RouteSpec mergeRouteSpec(RouteSpec fragmentSpec, RouteSpec opinionatedSpec) {
        KubernetesResourceUtil.mergeSimpleFields((Object)fragmentSpec, (Object)opinionatedSpec);
        if (fragmentSpec.getAlternateBackends() == null && opinionatedSpec.getAlternateBackends() != null) {
            fragmentSpec.setAlternateBackends(opinionatedSpec.getAlternateBackends());
        }
        if (fragmentSpec.getPort() == null && opinionatedSpec.getPort() != null) {
            fragmentSpec.setPort(opinionatedSpec.getPort());
        }
        if (fragmentSpec.getTls() == null && opinionatedSpec.getTls() != null) {
            fragmentSpec.setTls(opinionatedSpec.getTls());
        }
        if (fragmentSpec.getTo() == null && opinionatedSpec.getTo() != null) {
            fragmentSpec.setTo(opinionatedSpec.getTo());
        }
        return fragmentSpec;
    }

    static int getRouteIndexWithName(KubernetesListBuilder listBuilder, String name) {
        int routeInListIndex = -1;
        for (int index = 0; index < listBuilder.buildItems().size(); ++index) {
            HasMetadata item = (HasMetadata)listBuilder.getItems().get(index);
            if (item == null || item.getMetadata() == null || !item.getMetadata().getName().equals(name) || !(item instanceof Route)) continue;
            routeInListIndex = index;
        }
        return routeInListIndex;
    }

    private static void handleTlsTermination(RouteBuilder routeBuilder, String tlsTermination, String edgeTerminationPolicy, boolean isRouteWithTLS) {
        if (isRouteWithTLS) {
            ((RouteFluent.SpecNested)((RouteSpecFluent.TlsNested)((RouteSpecFluent.TlsNested)routeBuilder.editSpec().editOrNewTls().withInsecureEdgeTerminationPolicy(edgeTerminationPolicy)).withTermination(tlsTermination)).endTls()).endSpec();
        }
    }

    static Route createOpinionatedRouteFromService(ServiceBuilder serviceBuilder, String routeDomainPostfix, String tlsTermination, String edgeTerminationPolicy, boolean isRouteWithTls) {
        ObjectMeta serviceMetadata = serviceBuilder.buildMetadata();
        if (serviceMetadata != null) {
            String name = serviceMetadata.getName();
            RoutePort routePort = RouteEnricher.createRoutePort(serviceBuilder);
            if (routePort != null) {
                RouteBuilder routeBuilder = (RouteBuilder)((RouteFluent.SpecNested)((RouteFluent.SpecNested)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteFluent.SpecNested)((RouteBuilder)new RouteBuilder().withMetadata(serviceMetadata)).withNewSpec().withPort(routePort)).withNewTo().withKind("Service")).withName(name)).endTo()).withHost(routeDomainPostfix.isEmpty() ? null : routeDomainPostfix)).endSpec();
                RouteEnricher.handleTlsTermination(routeBuilder, tlsTermination, edgeTerminationPolicy, isRouteWithTls);
                KubernetesResourceUtil.removeLabel((ObjectMeta)routeBuilder.buildMetadata(), (String)EXPOSE_LABEL, (String)"true");
                KubernetesResourceUtil.removeLabel((ObjectMeta)routeBuilder.buildMetadata(), (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
                routeBuilder.withNewMetadataLike(routeBuilder.buildMetadata());
                return routeBuilder.build();
            }
        }
        return null;
    }

    static boolean isExposedService(ObjectMeta objectMeta) {
        return KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)EXPOSE_LABEL, (String)"true") || KubernetesResourceUtil.containsLabelInMetadata((ObjectMeta)objectMeta, (String)JKubeAnnotations.SERVICE_EXPOSE_URL.value(), (String)"true");
    }

    private static enum Config implements Configs.Config
    {
        GENERATE_ROUTE("generateRoute", "true"),
        TLS_TERMINATION("tlsTermination", null),
        TLS_INSECURE_EDGE_TERMINATION_POLICY("tlsInsecureEdgeTerminationPolicy", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

