/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.util.Optional;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.visitor.MetadataVisitor;

public class DefaultMetadataEnricher
extends BaseEnricher {
    private MetadataVisitor<?>[] metaDataVisitors = null;
    private final ProcessorConfig defaultEnricherConfig;
    private final ResourceConfig resourceConfig;

    public DefaultMetadataEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-metadata");
        this.defaultEnricherConfig = Optional.ofNullable(buildContext.getConfiguration().getProcessorConfig()).orElse(ProcessorConfig.EMPTY);
        this.resourceConfig = buildContext.getConfiguration().getResource();
    }

    private void init() {
        this.metaDataVisitors = new MetadataVisitor[]{new MetadataVisitor.DeploymentBuilderVisitor(this.resourceConfig), new MetadataVisitor.DeploymentConfigBuilderVisitor(this.resourceConfig), new MetadataVisitor.ReplicaSet(this.resourceConfig), new MetadataVisitor.ReplicationControllerBuilderVisitor(this.resourceConfig), new MetadataVisitor.ServiceBuilderVisitor(this.resourceConfig), new MetadataVisitor.PodTemplateSpecBuilderVisitor(this.resourceConfig), new MetadataVisitor.DaemonSetBuilderVisitor(this.resourceConfig), new MetadataVisitor.StatefulSetBuilderVisitor(this.resourceConfig), new MetadataVisitor.JobBuilderVisitor(this.resourceConfig), new MetadataVisitor.ImageStreamBuilderVisitor(this.resourceConfig), new MetadataVisitor.BuildConfigBuilderVisitor(this.resourceConfig), new MetadataVisitor.BuildBuilderVisitor(this.resourceConfig), new MetadataVisitor.IngressBuilderVisitor(this.resourceConfig)};
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.init();
        this.enrichLabels(this.defaultEnricherConfig, builder);
    }

    private void enrichLabels(ProcessorConfig config, KubernetesListBuilder builder) {
        this.visit(config, builder, this.metaDataVisitors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(ProcessorConfig config, KubernetesListBuilder builder, MetadataVisitor<?>[] visitors) {
        MetadataVisitor.setProcessorConfig((ProcessorConfig)config);
        try {
            for (MetadataVisitor<?> visitor : visitors) {
                builder.accept(visitor);
            }
        }
        finally {
            MetadataVisitor.clearProcessorConfig();
        }
    }
}

