/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.enricher.api.visitor;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.ServiceAccountFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluentImpl;
import io.fabric8.kubernetes.api.model.batch.v1.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluent;
import io.fabric8.kubernetes.api.model.batch.v1.JobFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.BuildFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RouteFluentImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.config.resource.MetaDataConfig;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;

public class MetadataVisitor<T extends VisitableBuilder>
extends TypedVisitor<T> {
    private final Class<T> clazz;
    private final Supplier<Properties> annotationSupplier;
    private final Supplier<Properties> labelSupplier;
    private final Function<T, ObjectMetaFluent<?>> objectMeta;
    private final Function<ObjectMetaFluent<?>, Runnable> endMetadata;

    public MetadataVisitor(Class<T> clazz, Supplier<Properties> annotationSupplier, Supplier<Properties> labelSupplier, Function<T, ObjectMetaFluent<?>> objectMeta) {
        this(clazz, annotationSupplier, labelSupplier, objectMeta, null);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    public void visit(T item) {
        ObjectMetaFluent<?> omf = this.objectMeta.apply(item);
        omf.withAnnotations(this.overlayMap(this.annotationSupplier.get(), omf.getAnnotations())).withLabels(this.overlayMap(this.labelSupplier.get(), omf.getLabels()));
        Optional.ofNullable(this.endMetadata).map(em -> (Runnable)em.apply(omf)).ifPresent(Runnable::run);
    }

    private Map<String, String> overlayMap(Properties properties, Map<String, String> originalMap) {
        HashMap<String, String> ret = new HashMap<String, String>(Optional.ofNullable(originalMap).orElse(Collections.emptyMap()));
        for (Map.Entry entry : PropertiesUtil.toMap((Properties)properties).entrySet()) {
            ret.putIfAbsent((String)entry.getKey(), this.appendTrailingNewLineIfMultiline((String)entry.getValue()));
        }
        return ret;
    }

    private static MetaDataConfig getAnnotations(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getAnnotations).orElse(new MetaDataConfig());
    }

    private static MetaDataConfig getLabels(ResourceConfig resourceConfig) {
        return Optional.ofNullable(resourceConfig).map(ResourceConfig::getLabels).orElse(new MetaDataConfig());
    }

    private String appendTrailingNewLineIfMultiline(String value) {
        if (value.contains(System.lineSeparator()) && !value.endsWith(System.lineSeparator())) {
            return value + System.lineSeparator();
        }
        return value;
    }

    public static MetadataVisitor<ObjectMetaBuilder> metadata(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ObjectMetaBuilder>(ObjectMetaBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), omb -> omb);
    }

    public static MetadataVisitor<DeploymentBuilder> deployment(ResourceConfig resourceConfig) {
        return new MetadataVisitor<DeploymentBuilder>(DeploymentBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getDeployment(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getDeployment(), io.fabric8.kubernetes.api.model.apps.DeploymentFluentImpl::editOrNewMetadata, omf -> () -> ((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder> extensionsDeployment(ResourceConfig resourceConfig) {
        return new MetadataVisitor<io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder>(io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getDeployment(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getDeployment(), DeploymentFluentImpl::editOrNewMetadata, omf -> () -> ((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<DeploymentConfigBuilder> deploymentConfig(ResourceConfig resourceConfig) {
        return new MetadataVisitor<DeploymentConfigBuilder>(DeploymentConfigBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getDeployment(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getDeployment(), DeploymentConfigFluentImpl::editOrNewMetadata, omf -> () -> ((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<ReplicaSetBuilder> replicaSet(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ReplicaSetBuilder>(ReplicaSetBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getReplicaSet(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getReplicaSet(), ReplicaSetFluentImpl::editOrNewMetadata, omf -> () -> ((ReplicaSetFluent.MetadataNested)((ReplicaSetFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<ReplicationControllerBuilder> replicationController(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ReplicationControllerBuilder>(ReplicationControllerBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getReplicaSet(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getReplicaSet(), ReplicationControllerFluentImpl::editOrNewMetadata, omf -> () -> ((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<ServiceBuilder> service(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ServiceBuilder>(ServiceBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getService(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getService(), ServiceFluentImpl::editOrNewMetadata, omf -> () -> ((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<PodTemplateSpecBuilder> podTemplateSpec(ResourceConfig resourceConfig) {
        return new MetadataVisitor<PodTemplateSpecBuilder>(PodTemplateSpecBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getPod(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getPod(), PodTemplateSpecFluentImpl::editOrNewMetadata, omf -> () -> ((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<DaemonSetBuilder> daemonSet(ResourceConfig resourceConfig) {
        return new MetadataVisitor<DaemonSetBuilder>(DaemonSetBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), DaemonSetFluentImpl::editOrNewMetadata, omf -> () -> ((DaemonSetFluent.MetadataNested)((DaemonSetFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<StatefulSetBuilder> statefulSet(ResourceConfig resourceConfig) {
        return new MetadataVisitor<StatefulSetBuilder>(StatefulSetBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), StatefulSetFluentImpl::editOrNewMetadata, omf -> () -> ((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<JobBuilder> job(ResourceConfig resourceConfig) {
        return new MetadataVisitor<JobBuilder>(JobBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), JobFluentImpl::editOrNewMetadata, omf -> () -> ((JobFluent.MetadataNested)((JobFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<ImageStreamBuilder> imageStream(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ImageStreamBuilder>(ImageStreamBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), ImageStreamFluentImpl::editOrNewMetadata, omf -> () -> ((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<BuildConfigBuilder> buildConfig(ResourceConfig resourceConfig) {
        return new MetadataVisitor<BuildConfigBuilder>(BuildConfigBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), BuildConfigFluentImpl::editOrNewMetadata, omf -> () -> ((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<BuildBuilder> build(ResourceConfig resourceConfig) {
        return new MetadataVisitor<BuildBuilder>(BuildBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getAll(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getAll(), BuildFluentImpl::editOrNewMetadata, omf -> () -> ((BuildFluent.MetadataNested)((BuildFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<io.fabric8.kubernetes.api.model.extensions.IngressBuilder> extensionsIngress(ResourceConfig resourceConfig) {
        return new MetadataVisitor<io.fabric8.kubernetes.api.model.extensions.IngressBuilder>(io.fabric8.kubernetes.api.model.extensions.IngressBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getIngress(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getIngress(), IngressFluentImpl::editOrNewMetadata, omf -> () -> ((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<IngressBuilder> ingressV1beta1(ResourceConfig resourceConfig) {
        return new MetadataVisitor<IngressBuilder>(IngressBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getIngress(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getIngress(), io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluentImpl::editOrNewMetadata, omf -> () -> ((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder> ingressV1(ResourceConfig resourceConfig) {
        return new MetadataVisitor<io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder>(io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getIngress(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getIngress(), io.fabric8.kubernetes.api.model.networking.v1.IngressFluentImpl::editOrNewMetadata, omf -> () -> ((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<ServiceAccountBuilder> serviceAccount(ResourceConfig resourceConfig) {
        return new MetadataVisitor<ServiceAccountBuilder>(ServiceAccountBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getServiceAccount(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getServiceAccount(), ServiceAccountFluentImpl::editOrNewMetadata, omf -> () -> ((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)omf)).endMetadata());
    }

    public static MetadataVisitor<RouteBuilder> route(ResourceConfig resourceConfig) {
        return new MetadataVisitor<RouteBuilder>(RouteBuilder.class, () -> ((MetaDataConfig)MetadataVisitor.getAnnotations(resourceConfig)).getRoute(), () -> ((MetaDataConfig)MetadataVisitor.getLabels(resourceConfig)).getRoute(), RouteFluentImpl::editOrNewMetadata, omf -> () -> ((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)omf)).endMetadata());
    }

    public MetadataVisitor(Class<T> clazz, Supplier<Properties> annotationSupplier, Supplier<Properties> labelSupplier, Function<T, ObjectMetaFluent<?>> objectMeta, Function<ObjectMetaFluent<?>, Runnable> endMetadata) {
        this.clazz = clazz;
        this.annotationSupplier = annotationSupplier;
        this.labelSupplier = labelSupplier;
        this.objectMeta = objectMeta;
        this.endMetadata = endMetadata;
    }
}

