/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.config.service.ApplyService;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.UndeployService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class KubernetesUndeployService
implements UndeployService {
    private final JKubeServiceHub jKubeServiceHub;
    private final KitLogger logger;
    private static final Predicate<HasMetadata> isCustomResource = GenericKubernetesResource.class::isInstance;

    public KubernetesUndeployService(JKubeServiceHub jKubeServiceHub, KitLogger logger) {
        this.jKubeServiceHub = jKubeServiceHub;
        this.logger = logger;
    }

    @Override
    public void undeploy(List<File> resourceDirs, ResourceConfig resourceConfig, File ... manifestFiles) throws IOException {
        String fallbackNamespace = KubernetesClientUtil.resolveFallbackNamespace(resourceConfig, this.jKubeServiceHub.getClusterAccess());
        List manifests = Stream.of(manifestFiles).filter(Objects::nonNull).filter(File::exists).filter(File::isFile).collect(Collectors.toList());
        ArrayList<HasMetadata> entities = new ArrayList<HasMetadata>();
        for (File manifest : manifests) {
            entities.addAll(KubernetesHelper.loadResources((File)manifest));
        }
        if (entities.isEmpty()) {
            this.logger.warn("No such generated manifests found for this project, ignoring.", new Object[0]);
            return;
        }
        List<HasMetadata> undeployEntities = ApplyService.getK8sListWithNamespaceFirst(entities);
        Collections.reverse(undeployEntities);
        this.undeployCustomResources(resourceConfig.getNamespace(), fallbackNamespace, undeployEntities);
        this.undeployResources(resourceConfig.getNamespace(), fallbackNamespace, undeployEntities);
    }

    private void undeployCustomResources(String currentNamespace, String fallbackNamespace, List<HasMetadata> entities) {
        Consumer<HasMetadata> customResourceDeleter = this.customResourceDeleter(currentNamespace, fallbackNamespace);
        entities.stream().filter(isCustomResource).forEach(customResourceDeleter);
    }

    private void undeployResources(String namespace, String fallbackNamespace, List<HasMetadata> entities) {
        Consumer<HasMetadata> resourceDeleter = this.resourceDeleter(namespace, fallbackNamespace);
        entities.stream().filter(isCustomResource.negate()).forEach(resourceDeleter);
    }

    protected Consumer<HasMetadata> resourceDeleter(String namespace, String fallbackNamespace) {
        return resource -> {
            String undeployNamespace = KubernetesClientUtil.applicableNamespace(resource, namespace, fallbackNamespace);
            this.logger.info("Deleting resource %s %s/%s", new Object[]{KubernetesHelper.getKind((HasMetadata)resource), undeployNamespace, KubernetesHelper.getName((HasMetadata)resource)});
            ((GracePeriodConfigurable)this.jKubeServiceHub.getClient().resource(resource).inNamespace(undeployNamespace).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
        };
    }

    protected Consumer<HasMetadata> customResourceDeleter(String namespace, String fallbackNamespace) {
        return customResource -> {
            String undeployNamespace = KubernetesClientUtil.applicableNamespace(customResource, namespace, fallbackNamespace);
            this.deleteCustomResourceIfPresent((GenericKubernetesResource)customResource, undeployNamespace);
        };
    }

    private void deleteCustomResourceIfPresent(GenericKubernetesResource customResource, String namespace) {
        GenericKubernetesResource cr = KubernetesClientUtil.doGetCustomResource(this.jKubeServiceHub.getClient(), customResource, namespace);
        if (cr != null) {
            this.deleteCustomResource(customResource, namespace, customResource.getApiVersion(), customResource.getKind());
        }
    }

    private void deleteCustomResource(GenericKubernetesResource customResource, String namespace, String apiVersion, String kind) {
        String name = customResource.getMetadata().getName();
        String apiVersionAndKind = KubernetesHelper.getFullyQualifiedApiGroupWithKind((HasMetadata)customResource);
        try {
            this.logger.info("Deleting Custom Resource %s %s", new Object[]{apiVersionAndKind, name});
            ((Resource)((NonNamespaceOperation)this.jKubeServiceHub.getClient().genericKubernetesResources(apiVersion, kind).inNamespace(namespace)).withName(name)).delete();
        }
        catch (Exception exception) {
            this.logger.error("Unable to undeploy %s %s/%s", new Object[]{apiVersionAndKind, namespace, name});
        }
    }

    protected JKubeServiceHub getjKubeServiceHub() {
        return this.jKubeServiceHub;
    }

    protected KitLogger getLogger() {
        return this.logger;
    }
}

