/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.kubernetes;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.jkube.kit.build.service.docker.DockerServiceHub;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.kit.config.service.AbstractImageBuildService;
import org.eclipse.jkube.kit.config.service.BuildServiceConfig;
import org.eclipse.jkube.kit.config.service.JKubeServiceException;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;

public class DockerBuildService
extends AbstractImageBuildService {
    private final RuntimeMode runtimeMode;
    private final BuildServiceConfig buildServiceConfig;
    private final JKubeConfiguration jKubeConfiguration;
    private final DockerServiceHub dockerServices;

    public DockerBuildService(JKubeServiceHub jKubeServiceHub) {
        super(jKubeServiceHub);
        this.runtimeMode = jKubeServiceHub.getRuntimeMode();
        this.buildServiceConfig = Objects.requireNonNull(jKubeServiceHub.getBuildServiceConfig(), "BuildServiceConfig is required");
        this.jKubeConfiguration = Objects.requireNonNull(jKubeServiceHub.getConfiguration(), "JKubeConfiguration is required");
        this.dockerServices = Objects.requireNonNull(jKubeServiceHub.getDockerServiceHub(), "Docker Service Hub is required");
    }

    @Override
    public boolean isApplicable() {
        return this.runtimeMode == RuntimeMode.KUBERNETES;
    }

    @Override
    public void buildSingleImage(ImageConfiguration imageConfig) throws JKubeServiceException {
        try {
            this.dockerServices.getBuildService().buildImage(imageConfig, this.buildServiceConfig.getImagePullManager(), this.jKubeConfiguration);
            this.dockerServices.getBuildService().tagImage(imageConfig.getName(), imageConfig);
        }
        catch (IOException ex) {
            throw new JKubeServiceException("Error while trying to build the image: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void pushSingleImage(ImageConfiguration imageConfiguration, int retries, RegistryConfig registryConfig, boolean skipTag) throws JKubeServiceException {
        try {
            this.dockerServices.getRegistryService().pushImage(imageConfiguration, retries, registryConfig, skipTag);
        }
        catch (IOException ex) {
            throw new JKubeServiceException("Error while trying to push the image: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void postProcess() {
    }
}

